/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import junit.framework.TestSuite;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.Charsets;
import org.apache.james.mime4j.ExampleMessageTestCase;
import org.apache.james.mime4j.ExampleMessageTestCaseFactory;
import org.apache.james.mime4j.ExampleMessageTestSuiteBuilder;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.parser.MimeStreamParser;
import org.apache.james.mime4j.parser.TestHandler;
import org.apache.james.mime4j.stream.MimeConfig;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.AllTests;

@RunWith(value=AllTests.class)
public class MimeStreamParserExampleMessagesTest
extends ExampleMessageTestCase {
    public static TestSuite suite() throws IOException {
        ExampleMessageTestSuiteBuilder testSuiteBuilder = new ExampleMessageTestSuiteBuilder(new ExampleMessageTestCaseFactory(){

            public ExampleMessageTestCase create(File file, URL resource) throws IOException {
                return new MimeStreamParserExampleMessagesTest(file, resource);
            }
        });
        return testSuiteBuilder.build();
    }

    public MimeStreamParserExampleMessagesTest(File file, URL resource) {
        super(file, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTest() throws Exception {
        MimeConfig config = this.getConfig();
        TestHandler handler = new TestHandler();
        InputStream msgstream = this.getResource().openStream();
        try {
            MimeStreamParser parser = new MimeStreamParser(config);
            parser.setContentHandler((ContentHandler)handler);
            parser.parse(msgstream);
        }
        finally {
            msgstream.close();
        }
        String result = handler.sb.toString();
        URL xmlFileUrl = new URL(this.getResourceBase() + ".xml");
        try {
            String expected;
            InputStream contentstream = xmlFileUrl.openStream();
            try {
                expected = IOUtils.toString((InputStream)contentstream, (String)Charsets.ISO_8859_1.name());
            }
            finally {
                contentstream.close();
            }
            Assert.assertEquals((Object)expected, (Object)result);
        }
        catch (FileNotFoundException ex) {
            File expectedFileTemplate = new File(this.getFilenameBase() + ".xml.expected");
            FileOutputStream outstream = new FileOutputStream(expectedFileTemplate);
            try {
                IOUtils.write((String)result, (OutputStream)outstream, (String)Charsets.ISO_8859_1.name());
            }
            finally {
                outstream.close();
            }
            Assert.fail((String)"Expected file created.");
        }
    }
}

