/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.james.mime4j.ExampleMail;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.MimeTokenStream;
import org.apache.james.mime4j.stream.RecursionMode;

public class MimeStreamTokenMessageRfc822Test
extends TestCase {
    MimeTokenStream stream;

    protected void setUp() throws Exception {
        super.setUp();
        this.stream = new MimeTokenStream();
        this.stream.parse((InputStream)new ByteArrayInputStream(ExampleMail.MIME_RFC822_SIMPLE_BYTES));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testShouldParseMessageRFC822CorrectWithDefaultConfiguration() throws Exception {
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_START_MESSAGE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_OF_STREAM);
    }

    public void testShouldParseMessageRFC822CorrectWithNoRecurse() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_NO_RECURSE);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_OF_STREAM);
    }

    public void testShouldParseMessageRFC822CorrectWithFlat() throws Exception {
        this.stream.setRecursionMode(RecursionMode.M_FLAT);
        this.nextIs(EntityState.T_START_HEADER);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_FIELD);
        this.nextIs(EntityState.T_END_HEADER);
        this.nextIs(EntityState.T_BODY);
        this.nextIs(EntityState.T_END_MESSAGE);
        this.nextIs(EntityState.T_END_OF_STREAM);
    }

    private void nextIs(EntityState state) throws Exception {
        MimeStreamTokenMessageRfc822Test.assertEquals((String)MimeTokenStream.stateToString((EntityState)state), (String)MimeTokenStream.stateToString((EntityState)this.stream.next()));
    }
}

