/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import com.google.common.base.Strings;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStore;
import org.apache.james.blob.api.ObjectStoreException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface BlobStoreContract {
    public static final byte[] EMPTY_BYTEARRAY = new byte[0];
    public static final byte[] SHORT_BYTEARRAY = "toto".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ELEVEN_KILOBYTES = Strings.repeat((String)"0123456789\n", (int)1000).getBytes(StandardCharsets.UTF_8);
    public static final byte[] TWELVE_MEGABYTES = Strings.repeat((String)"0123456789\r\n", (int)0x100000).getBytes(StandardCharsets.UTF_8);

    public BlobStore testee();

    public BlobId.Factory blobIdFactory();

    @Test
    default public void saveShouldThrowWhenNullData() {
        Assertions.assertThatThrownBy(() -> {
            BlobId cfr_ignored_0 = (BlobId)this.testee().save((byte[])null).block();
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void saveShouldThrowWhenNullInputStream() {
        Assertions.assertThatThrownBy(() -> {
            BlobId cfr_ignored_0 = (BlobId)this.testee().save((InputStream)null).block();
        }).isInstanceOf(NullPointerException.class);
    }

    @Test
    default public void saveShouldSaveEmptyData() {
        BlobId blobId = (BlobId)this.testee().save(EMPTY_BYTEARRAY).block();
        byte[] bytes = (byte[])this.testee().readBytes(blobId).block();
        Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEmpty();
    }

    @Test
    default public void saveShouldSaveEmptyInputStream() {
        BlobId blobId = (BlobId)this.testee().save((InputStream)new ByteArrayInputStream(EMPTY_BYTEARRAY)).block();
        byte[] bytes = (byte[])this.testee().readBytes(blobId).block();
        Assertions.assertThat((String)new String(bytes, StandardCharsets.UTF_8)).isEmpty();
    }

    @Test
    default public void saveShouldReturnBlobId() {
        BlobId blobId = (BlobId)this.testee().save(SHORT_BYTEARRAY).block();
        Assertions.assertThat((Object)blobId).isEqualTo((Object)this.blobIdFactory().from("31f7a65e315586ac198bd798b6629ce4903d0899476d5741a9f32e2e521b6a66"));
    }

    @Test
    default public void saveShouldReturnBlobIdOfInputStream() {
        BlobId blobId = (BlobId)this.testee().save((InputStream)new ByteArrayInputStream(SHORT_BYTEARRAY)).block();
        Assertions.assertThat((Object)blobId).isEqualTo((Object)this.blobIdFactory().from("31f7a65e315586ac198bd798b6629ce4903d0899476d5741a9f32e2e521b6a66"));
    }

    @Test
    default public void readBytesShouldThrowWhenNoExisting() {
        Assertions.assertThatThrownBy(() -> {
            byte[] cfr_ignored_0 = (byte[])this.testee().readBytes(this.blobIdFactory().from("unknown")).block();
        }).isExactlyInstanceOf(ObjectStoreException.class);
    }

    @Test
    default public void readBytesShouldReturnSavedData() {
        BlobId blobId = (BlobId)this.testee().save(SHORT_BYTEARRAY).block();
        byte[] bytes = (byte[])this.testee().readBytes(blobId).block();
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)SHORT_BYTEARRAY);
    }

    @Test
    default public void readBytesShouldReturnLongSavedData() {
        BlobId blobId = (BlobId)this.testee().save(ELEVEN_KILOBYTES).block();
        byte[] bytes = (byte[])this.testee().readBytes(blobId).block();
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)ELEVEN_KILOBYTES);
    }

    @Test
    default public void readBytesShouldReturnBigSavedData() {
        BlobId blobId = (BlobId)this.testee().save(TWELVE_MEGABYTES).block();
        byte[] bytes = (byte[])this.testee().readBytes(blobId).block();
        Assertions.assertThat((byte[])bytes).isEqualTo((Object)TWELVE_MEGABYTES);
    }

    @Test
    default public void readShouldThrowWhenNoExistingStream() {
        Assertions.assertThatThrownBy(() -> this.testee().read(this.blobIdFactory().from("unknown"))).isInstanceOf(ObjectStoreException.class);
    }

    @Test
    default public void readShouldReturnSavedData() {
        BlobId blobId = (BlobId)this.testee().save(SHORT_BYTEARRAY).block();
        InputStream read = this.testee().read(blobId);
        Assertions.assertThat((InputStream)read).hasSameContentAs((InputStream)new ByteArrayInputStream(SHORT_BYTEARRAY));
    }

    @Test
    default public void readShouldReturnLongSavedData() {
        BlobId blobId = (BlobId)this.testee().save(ELEVEN_KILOBYTES).block();
        InputStream read = this.testee().read(blobId);
        Assertions.assertThat((InputStream)read).hasSameContentAs((InputStream)new ByteArrayInputStream(ELEVEN_KILOBYTES));
    }

    @Test
    default public void readShouldReturnBigSavedData() {
        BlobId blobId = (BlobId)this.testee().save(TWELVE_MEGABYTES).block();
        InputStream read = this.testee().read(blobId);
        Assertions.assertThat((InputStream)read).hasSameContentAs((InputStream)new ByteArrayInputStream(TWELVE_MEGABYTES));
    }
}

