/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import java.nio.charset.StandardCharsets;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.util.ClassLoaderUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class HashBlobIdTest {
    private static final HashBlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();

    @Test
    public void shouldRespectBeanContract() {
        EqualsVerifier.forClass(HashBlobId.class).verify();
    }

    @Test
    public void fromShouldConstructBlobId() {
        String id = "111";
        Assertions.assertThat((Object)BLOB_ID_FACTORY.from(id)).isEqualTo((Object)new HashBlobId(id));
    }

    @Test
    public void fromShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> BLOB_ID_FACTORY.from(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void fromShouldThrowOnEmpty() {
        Assertions.assertThatThrownBy(() -> BLOB_ID_FACTORY.from("")).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void forPayloadShouldThrowOnNull() {
        Assertions.assertThatThrownBy(() -> BLOB_ID_FACTORY.forPayload(null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    public void forPayloadShouldHashEmptyArray() {
        HashBlobId blobId = BLOB_ID_FACTORY.forPayload(new byte[0]);
        Assertions.assertThat((String)blobId.asString()).isEqualTo((Object)"e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855");
    }

    @Test
    public void forPayloadShouldHashArray() {
        HashBlobId blobId = BLOB_ID_FACTORY.forPayload("content".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThat((String)blobId.asString()).isEqualTo((Object)"ed7002b439e9ac845f22357d822bac1444730fbdb6016d3ec9432297b9ec9f73");
    }

    @Test
    public void forPayloadShouldCalculateDifferentHashesWhenCraftedSha1Collision() throws Exception {
        byte[] payload1 = ClassLoaderUtils.getSystemResourceAsByteArray((String)"shattered-1.pdf");
        byte[] payload2 = ClassLoaderUtils.getSystemResourceAsByteArray((String)"shattered-2.pdf");
        HashBlobId blobId1 = BLOB_ID_FACTORY.forPayload(payload1);
        HashBlobId blobId2 = BLOB_ID_FACTORY.forPayload(payload2);
        Assertions.assertThat((Object)blobId1).isNotEqualTo((Object)blobId2);
    }
}

