/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.blob.api;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.BlobStoreContract;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.TimeMetric;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public interface MetricableBlobStoreContract
extends BlobStoreContract {
    @RegisterExtension
    public static final MetricableBlobStoreExtension metricsTestExtension = new MetricableBlobStoreExtension();
    public static final byte[] BYTES_CONTENT = "bytes content".getBytes(StandardCharsets.UTF_8);

    @Test
    default public void saveBytesShouldPublishSaveBytesTimerMetrics() {
        this.testee().save(BYTES_CONTENT).block();
        this.testee().save(BYTES_CONTENT).block();
        ((TimeMetric)Mockito.verify((Object)metricsTestExtension.saveBytesTimeMetric, (VerificationMode)Mockito.times((int)2))).stopAndPublish();
    }

    @Test
    default public void saveInputStreamShouldPublishSaveInputStreamTimerMetrics() {
        this.testee().save((InputStream)new ByteArrayInputStream(BYTES_CONTENT)).block();
        this.testee().save((InputStream)new ByteArrayInputStream(BYTES_CONTENT)).block();
        this.testee().save((InputStream)new ByteArrayInputStream(BYTES_CONTENT)).block();
        ((TimeMetric)Mockito.verify((Object)metricsTestExtension.saveInputStreamTimeMetric, (VerificationMode)Mockito.times((int)3))).stopAndPublish();
    }

    @Test
    default public void readBytesShouldPublishReadBytesTimerMetrics() {
        BlobId blobId = (BlobId)this.testee().save(BYTES_CONTENT).block();
        this.testee().readBytes(blobId).block();
        this.testee().readBytes(blobId).block();
        ((TimeMetric)Mockito.verify((Object)metricsTestExtension.readBytesTimeMetric, (VerificationMode)Mockito.times((int)2))).stopAndPublish();
    }

    @Test
    default public void readShouldPublishReadTimerMetrics() {
        BlobId blobId = (BlobId)this.testee().save(BYTES_CONTENT).block();
        this.testee().read(blobId);
        this.testee().read(blobId);
        ((TimeMetric)Mockito.verify((Object)metricsTestExtension.readTimeMetric, (VerificationMode)Mockito.times((int)2))).stopAndPublish();
    }

    public static class MetricableBlobStoreExtension
    implements BeforeEachCallback {
        private MetricFactory metricFactory;
        private TimeMetric saveBytesTimeMetric;
        private TimeMetric saveInputStreamTimeMetric;
        private TimeMetric readBytesTimeMetric;
        private TimeMetric readTimeMetric;

        public void beforeEach(ExtensionContext extensionContext) {
            this.metricFactory = (MetricFactory)Mockito.spy(MetricFactory.class);
            this.saveBytesTimeMetric = (TimeMetric)Mockito.spy(TimeMetric.class);
            this.saveInputStreamTimeMetric = (TimeMetric)Mockito.spy(TimeMetric.class);
            this.readBytesTimeMetric = (TimeMetric)Mockito.spy(TimeMetric.class);
            this.readTimeMetric = (TimeMetric)Mockito.spy(TimeMetric.class);
            this.setupExpectations();
        }

        public MetricFactory getMetricFactory() {
            return this.metricFactory;
        }

        private void setupExpectations() {
            Mockito.when((Object)this.metricFactory.timer("blobStore:saveBytes")).thenReturn((Object)this.saveBytesTimeMetric);
            Mockito.when((Object)this.metricFactory.timer("blobStore:saveInputStream")).thenReturn((Object)this.saveInputStreamTimeMetric);
            Mockito.when((Object)this.metricFactory.timer("blobStore:readBytes")).thenReturn((Object)this.readBytesTimeMetric);
            Mockito.when((Object)this.metricFactory.timer("blobStore:read")).thenReturn((Object)this.readTimeMetric);
        }
    }
}

