/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.blobstore.validation;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.eventsourcing.EventId;
import org.apache.james.modules.blobstore.validation.StorageStrategyChanged;
import org.apache.james.modules.blobstore.validation.StorageStrategyChangedDTO;
import org.apache.james.server.blob.deduplication.StorageStrategy;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.Test;

class StorageStrategyChangedDTOTest {
    private static final int EVENT_ID_SERIALIZED = 10;
    private static final EventId EVENT_ID = EventId.fromSerialized((int)10);
    private static final String STORAGE_STRATEGY_AGGREGATE_KEY = "aggrKey";

    StorageStrategyChangedDTOTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(StorageStrategyChangedDTO.class).verify();
    }

    @Test
    void fromShouldThrowWhenStorageStrategyAddedIsNull() {
        Assertions.assertThatThrownBy(() -> StorageStrategyChangedDTO.from(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromShouldReturnCorrespondingDTO() {
        StorageStrategyChanged configurationChanged = new StorageStrategyChanged(EVENT_ID, () -> STORAGE_STRATEGY_AGGREGATE_KEY, StorageStrategy.DEDUPLICATION);
        StorageStrategyChangedDTO dto = StorageStrategyChangedDTO.from((StorageStrategyChanged)configurationChanged);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(dto.getEventId()).isEqualTo(10);
            softly.assertThat(dto.getType()).isEqualTo("storage-strategy-changed");
            softly.assertThat(dto.getStorageStrategy()).isEqualTo(StorageStrategy.DEDUPLICATION.name());
        });
    }

    @Test
    void toEventShouldReturnCorrespondingStorageStrategyChangedEvent() {
        StorageStrategyChangedDTO dto = new StorageStrategyChangedDTO(10, STORAGE_STRATEGY_AGGREGATE_KEY, "storage-strategy-changed", StorageStrategy.DEDUPLICATION.name());
        StorageStrategyChanged event = dto.toEvent();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)event.eventId()).isEqualTo((Object)EVENT_ID);
            softly.assertThat(event.getAggregateId().asAggregateKey()).isEqualTo(STORAGE_STRATEGY_AGGREGATE_KEY);
            softly.assertThat((Comparable)event.getStorageStrategy()).isEqualTo((Object)StorageStrategy.DEDUPLICATION);
        });
    }
}

