/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.ldap.LdapRepositoryConfiguration;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.utils.ConfigurationPerformer;

public class LdapUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(ReadOnlyUsersLDAPRepository.class).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to(ReadOnlyUsersLDAPRepository.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigurationPerformer.class).addBinding().to(LdapUsersRepositoryConfigurationPerformer.class);
    }

    @Provides
    @Singleton
    public LdapRepositoryConfiguration provideConfiguration(ConfigurationProvider configurationProvider) throws ConfigurationException {
        return LdapRepositoryConfiguration.from((HierarchicalConfiguration)configurationProvider.getConfiguration("usersrepository"));
    }

    @Singleton
    public static class LdapUsersRepositoryConfigurationPerformer
    implements ConfigurationPerformer {
        private final LdapRepositoryConfiguration configuration;
        private final ReadOnlyUsersLDAPRepository usersRepository;

        @Inject
        public LdapUsersRepositoryConfigurationPerformer(LdapRepositoryConfiguration configuration, ReadOnlyUsersLDAPRepository usersRepository) {
            this.configuration = configuration;
            this.usersRepository = usersRepository;
        }

        public void initModule() {
            try {
                this.usersRepository.configure(this.configuration);
                this.usersRepository.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public List<Class<? extends Configurable>> forClasses() {
            return ImmutableList.of(ReadOnlyUsersLDAPRepository.class);
        }
    }
}

