/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.lib.AbstractDomainList;

public class CassandraDomainList
extends AbstractDomainList {
    private Session session;

    @Inject
    @Resource
    public void setSession(Session session) {
        this.session = session;
    }

    protected List<String> getDomainListInternal() throws DomainListException {
        return CassandraUtils.convertToStream((ResultSet)this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"domain"}).from("domains"))).map(row -> row.getString("domain")).collect(Collectors.toList());
    }

    public boolean containsDomain(String domain) throws DomainListException {
        return this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"domain"}).from("domains").where(QueryBuilder.eq((String)"domain", (Object)domain.toLowerCase(Locale.US)))).one() != null;
    }

    public void addDomain(String domain) throws DomainListException {
        boolean executed = this.session.execute((Statement)QueryBuilder.insertInto((String)"domains").ifNotExists().value("domain", (Object)domain.toLowerCase(Locale.US))).one().getBool(0);
        if (!executed) {
            throw new DomainListException(domain.toLowerCase(Locale.US) + " already exists.");
        }
    }

    public void removeDomain(String domain) throws DomainListException {
        ResultSet resultSet = this.session.execute((Statement)QueryBuilder.delete().from("domains").ifExists().where(QueryBuilder.eq((String)"domain", (Object)domain.toLowerCase(Locale.US))));
        if (!resultSet.one().getBool(0)) {
            throw new DomainListException(domain + " was not found");
        }
    }
}

