/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.rrt.cassandra;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Optional;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.james.rrt.api.RecipientRewriteTableException;
import org.apache.james.rrt.lib.AbstractRecipientRewriteTable;
import org.apache.james.rrt.lib.Mappings;
import org.apache.james.rrt.lib.MappingsImpl;

public class CassandraRecipientRewriteTable
extends AbstractRecipientRewriteTable {
    private Session session;

    @Inject
    @Resource
    public void setSession(Session session) {
        this.session = session;
    }

    protected void addMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        this.session.execute((Statement)QueryBuilder.insertInto((String)"rrt").value("user", (Object)this.getFixedUser(user)).value("domain", (Object)this.getFixedDomain(domain)).value("mapping", (Object)mapping));
    }

    protected void removeMappingInternal(String user, String domain, String mapping) throws RecipientRewriteTableException {
        this.session.execute((Statement)QueryBuilder.delete().from("rrt").where(QueryBuilder.eq((String)"user", (Object)this.getFixedUser(user))).and(QueryBuilder.eq((String)"domain", (Object)this.getFixedDomain(domain))).and(QueryBuilder.eq((String)"mapping", (Object)mapping)));
    }

    protected Mappings getUserDomainMappingsInternal(String user, String domain) throws RecipientRewriteTableException {
        return (Mappings)this.retrieveMappings(user, domain).orNull();
    }

    private Optional<Mappings> retrieveMappings(String user, String domain) {
        List mappings = this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"mapping"}).from("rrt").where(QueryBuilder.eq((String)"user", (Object)this.getFixedUser(user))).and(QueryBuilder.eq((String)"domain", (Object)this.getFixedDomain(domain)))).all().stream().map(row -> row.getString("mapping")).collect(Collectors.toList());
        return MappingsImpl.fromCollection(mappings).toOptional();
    }

    protected Map<String, Mappings> getAllMappingsInternal() throws RecipientRewriteTableException {
        Map<String, Mappings> map = this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"user", "domain", "mapping"}).from("rrt")).all().stream().map(row -> new UserMapping(row.getString("user"), row.getString("domain"), row.getString("mapping"))).collect(Collectors.toMap(UserMapping::asKey, userMapping -> MappingsImpl.fromRawString((String)userMapping.getMapping()), (first, second) -> first.union(second)));
        return map.isEmpty() ? null : map;
    }

    protected String mapAddressInternal(String user, String domain) throws RecipientRewriteTableException {
        Mappings mappings = (Mappings)this.retrieveMappings(user, domain).or(() -> (Mappings)this.retrieveMappings("*", domain).or(() -> (Mappings)this.retrieveMappings(user, "*").or((Object)MappingsImpl.empty())));
        return !mappings.isEmpty() ? mappings.serialize() : null;
    }

    private static class UserMapping {
        private final String user;
        private final String domain;
        private final String mapping;

        public UserMapping(String user, String domain, String mapping) {
            this.user = user;
            this.domain = domain;
            this.mapping = mapping;
        }

        public String getUser() {
            return this.user;
        }

        public String getDomain() {
            return this.domain;
        }

        public String getMapping() {
            return this.mapping;
        }

        public String asKey() {
            return this.getUser() + "@" + this.getDomain();
        }
    }
}

