/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;
import org.apache.james.sieve.cassandra.model.ActiveScriptInfo;

public class CassandraActiveScriptDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement insertActive;
    private final PreparedStatement deleteActive;
    private final PreparedStatement selectActiveName;

    @Inject
    public CassandraActiveScriptDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.insertActive = session.prepare((RegularStatement)QueryBuilder.insertInto((String)"sieve_active").value("script_name", (Object)QueryBuilder.bindMarker((String)"script_name")).value("user_name", (Object)QueryBuilder.bindMarker((String)"user_name")).value("date", (Object)QueryBuilder.bindMarker((String)"date")));
        this.deleteActive = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_active").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.selectActiveName = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"script_name", "date"}).from("sieve_active").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
    }

    public CompletableFuture<Optional<ActiveScriptInfo>> getActiveSctiptInfo(String username) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectActiveName.bind().setString("user_name", username)).thenApply(rowOptional -> rowOptional.map(row -> new ActiveScriptInfo(row.getString("script_name"), row.getDate("date"))));
    }

    public CompletableFuture<Void> unactivate(String username) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.deleteActive.bind().setString("user_name", username));
    }

    public CompletableFuture<Void> activate(String username, String scriptName) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.insertActive.bind().setString("user_name", username).setString("script_name", scriptName).setDate("date", new Date()));
    }
}

