/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraAsyncExecutor;

public class CassandraSieveQuotaDAO {
    private final CassandraAsyncExecutor cassandraAsyncExecutor;
    private final PreparedStatement selectClusterQuotaStatement;
    private final PreparedStatement selectSpaceUsedByUserStatement;
    private final PreparedStatement selectUserQuotaStatement;
    private final PreparedStatement updateClusterQuotaStatement;
    private final PreparedStatement updateUserQuotaStatement;
    private final PreparedStatement updateSpaceUsedStatement;
    private final PreparedStatement deleteClusterQuotaStatement;
    private final PreparedStatement deleteUserQuotaStatement;

    @Inject
    public CassandraSieveQuotaDAO(Session session) {
        this.cassandraAsyncExecutor = new CassandraAsyncExecutor(session);
        this.selectClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"value"}).from("sieve_cluster_quota").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
        this.selectSpaceUsedByUserStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"space_used"}).from("sieve_space").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.selectUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.select((String[])new String[]{"quota"}).from("sieve_quota").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.updateClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_cluster_quota").with(QueryBuilder.set((String)"value", (Object)QueryBuilder.bindMarker((String)"value"))).where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))));
        this.updateSpaceUsedStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_space").with(QueryBuilder.incr((String)"space_used", (BindMarker)QueryBuilder.bindMarker((String)"space_used"))).where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.updateUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.update((String)"sieve_quota").with(QueryBuilder.set((String)"quota", (Object)QueryBuilder.bindMarker((String)"quota"))).where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))));
        this.deleteClusterQuotaStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_cluster_quota").where(QueryBuilder.eq((String)"name", (Object)QueryBuilder.bindMarker((String)"name"))).ifExists());
        this.deleteUserQuotaStatement = session.prepare((RegularStatement)QueryBuilder.delete().from("sieve_quota").where(QueryBuilder.eq((String)"user_name", (Object)QueryBuilder.bindMarker((String)"user_name"))).ifExists());
    }

    public CompletableFuture<Long> spaceUsedBy(String user) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectSpaceUsedByUserStatement.bind().setString("user_name", user)).thenApply(optional -> optional.map(row -> row.getLong("space_used")).orElse(0L));
    }

    public CompletableFuture<Void> updateSpaceUsed(String user, long spaceUsed) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateSpaceUsedStatement.bind().setLong("space_used", spaceUsed).setString("user_name", user));
    }

    public CompletableFuture<Optional<Long>> getQuota() {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectClusterQuotaStatement.bind().setString("name", "cluster_quota")).thenApply(optional -> optional.map(row -> row.getLong("value")));
    }

    public CompletableFuture<Void> setQuota(long quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateClusterQuotaStatement.bind().setLong("value", quota).setString("name", "cluster_quota"));
    }

    public CompletableFuture<Boolean> removeQuota() {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.deleteClusterQuotaStatement.bind().setString("name", "cluster_quota"));
    }

    public CompletableFuture<Optional<Long>> getQuota(String user) {
        return this.cassandraAsyncExecutor.executeSingleRow((Statement)this.selectUserQuotaStatement.bind().setString("user_name", user)).thenApply(optional -> optional.map(row -> row.getLong("quota")));
    }

    public CompletableFuture<Void> setQuota(String user, long quota) {
        return this.cassandraAsyncExecutor.executeVoid((Statement)this.updateUserQuotaStatement.bind().setLong("quota", quota).setString("user_name", user));
    }

    public CompletableFuture<Boolean> removeQuota(String user) {
        return this.cassandraAsyncExecutor.executeReturnApplied((Statement)this.deleteUserQuotaStatement.bind().setString("user_name", user));
    }
}

