/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.james.sieve.cassandra.CassandraActiveScriptDAO;
import org.apache.james.sieve.cassandra.CassandraSieveDAO;
import org.apache.james.sieve.cassandra.CassandraSieveQuotaDAO;
import org.apache.james.sieve.cassandra.model.ActiveScriptInfo;
import org.apache.james.sieve.cassandra.model.Script;
import org.apache.james.sieve.cassandra.model.SieveQuota;
import org.apache.james.sieverepository.api.ScriptSummary;
import org.apache.james.sieverepository.api.SieveRepository;
import org.apache.james.sieverepository.api.exception.DuplicateException;
import org.apache.james.sieverepository.api.exception.IsActiveException;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.sieverepository.api.exception.ScriptNotFoundException;
import org.apache.james.sieverepository.api.exception.StorageException;
import org.apache.james.util.CompletableFutureUtil;
import org.apache.james.util.FluentFutureStream;
import org.joda.time.DateTime;

public class CassandraSieveRepository
implements SieveRepository {
    private final CassandraSieveDAO cassandraSieveDAO;
    private final CassandraSieveQuotaDAO cassandraSieveQuotaDAO;
    private final CassandraActiveScriptDAO cassandraActiveScriptDAO;

    @Inject
    public CassandraSieveRepository(CassandraSieveDAO cassandraSieveDAO, CassandraSieveQuotaDAO cassandraSieveQuotaDAO, CassandraActiveScriptDAO cassandraActiveScriptDAO) {
        this.cassandraSieveDAO = cassandraSieveDAO;
        this.cassandraSieveQuotaDAO = cassandraSieveQuotaDAO;
        this.cassandraActiveScriptDAO = cassandraActiveScriptDAO;
    }

    public DateTime getActivationDateForActiveScript(String user) throws StorageException, ScriptNotFoundException {
        return this.cassandraActiveScriptDAO.getActiveSctiptInfo(user).join().orElseThrow(ScriptNotFoundException::new).getActivationDate();
    }

    public void haveSpace(String user, String name, long newSize) throws QuotaExceededException, StorageException {
        this.throwOnOverQuota(user, this.spaceThatWillBeUsedByNewScript(user, name, newSize));
    }

    private void throwOnOverQuota(String user, CompletableFuture<Long> sizeDifference) throws QuotaExceededException, StorageException {
        CompletableFuture<Optional<Long>> userQuotaFuture = this.cassandraSieveQuotaDAO.getQuota(user);
        CompletableFuture<Optional<Long>> globalQuotaFuture = this.cassandraSieveQuotaDAO.getQuota();
        CompletableFuture<Long> spaceUsedFuture = this.cassandraSieveQuotaDAO.spaceUsedBy(user);
        new SieveQuota(spaceUsedFuture.join(), this.limitToUse(userQuotaFuture, globalQuotaFuture)).checkOverQuotaUponModification(sizeDifference.join());
    }

    public CompletableFuture<Long> spaceThatWillBeUsedByNewScript(String user, String name, long scriptSize) {
        return ((CompletableFuture)this.cassandraSieveDAO.getScript(user, name).thenApply(optional -> optional.map(Script::getSize).orElse(0L))).thenApply(sizeOfStoredScript -> scriptSize - sizeOfStoredScript);
    }

    private Optional<Long> limitToUse(CompletableFuture<Optional<Long>> userQuota, CompletableFuture<Optional<Long>> globalQuota) {
        if (userQuota.join().isPresent()) {
            return userQuota.join();
        }
        return globalQuota.join();
    }

    public void putScript(String user, String name, String content) throws QuotaExceededException, StorageException {
        CompletableFuture<Long> spaceUsed = this.spaceThatWillBeUsedByNewScript(user, name, content.length());
        this.throwOnOverQuota(user, spaceUsed);
        CompletableFuture.allOf(this.updateSpaceUsed(user, spaceUsed.join()), this.cassandraSieveDAO.insertScript(user, Script.builder().name(name).content(content).isActive(false).build())).join();
    }

    public CompletableFuture<Void> updateSpaceUsed(String user, long spaceUsed) {
        if (spaceUsed == 0L) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cassandraSieveQuotaDAO.updateSpaceUsed(user, spaceUsed);
    }

    public List<ScriptSummary> listScripts(String user) {
        return this.cassandraSieveDAO.listScripts(user).join();
    }

    public InputStream getActive(String user) throws ScriptNotFoundException {
        return IOUtils.toInputStream((String)((Script)((Optional)((CompletableFuture)this.cassandraActiveScriptDAO.getActiveSctiptInfo(user).thenCompose(optionalActiveName -> optionalActiveName.map(activeScriptInfo -> this.cassandraSieveDAO.getScript(user, activeScriptInfo.getName())).orElse(CompletableFuture.completedFuture(Optional.empty())))).join()).orElseThrow(ScriptNotFoundException::new)).getContent(), (Charset)StandardCharsets.UTF_8);
    }

    public void setActive(String user, String name) throws ScriptNotFoundException {
        CompletableFuture<Void> unactivateOldScriptFuture = this.unactivateOldScript(user);
        CompletionStage activateNewScript = this.updateScriptActivation(user, name, true).thenCompose(CompletableFutureUtil.composeIfTrue(() -> this.cassandraActiveScriptDAO.activate(user, name)));
        unactivateOldScriptFuture.join();
        if (!((Boolean)((CompletableFuture)activateNewScript).join()).booleanValue()) {
            throw new ScriptNotFoundException();
        }
    }

    private CompletableFuture<Void> unactivateOldScript(String user) {
        return this.cassandraActiveScriptDAO.getActiveSctiptInfo(user).thenCompose(scriptNameOptional -> scriptNameOptional.map(activeScriptInfo -> this.updateScriptActivation(user, activeScriptInfo.getName(), false).thenApply(any -> null)).orElse(CompletableFuture.completedFuture(null)));
    }

    private CompletableFuture<Boolean> updateScriptActivation(String user, String scriptName, boolean active) {
        if (!scriptName.equals("")) {
            return this.cassandraSieveDAO.updateScriptActivation(user, scriptName, active);
        }
        return this.cassandraActiveScriptDAO.unactivate(user).thenApply(any -> true);
    }

    public InputStream getScript(String user, String name) throws ScriptNotFoundException {
        return this.cassandraSieveDAO.getScript(user, name).join().map(script -> IOUtils.toInputStream((String)script.getContent(), (Charset)StandardCharsets.UTF_8)).orElseThrow(ScriptNotFoundException::new);
    }

    public void deleteScript(String user, String name) throws ScriptNotFoundException, IsActiveException {
        this.ensureIsNotActive(user, name);
        if (!this.cassandraSieveDAO.deleteScriptInCassandra(user, name).join().booleanValue()) {
            throw new ScriptNotFoundException();
        }
    }

    private void ensureIsNotActive(String user, String name) throws IsActiveException {
        Optional<String> activeName = this.cassandraActiveScriptDAO.getActiveSctiptInfo(user).join().map(ActiveScriptInfo::getName);
        if (activeName.isPresent() && name.equals(activeName.get())) {
            throw new IsActiveException();
        }
    }

    public void renameScript(String user, String oldName, String newName) throws ScriptNotFoundException, DuplicateException {
        CompletionStage scriptExistsFuture = this.cassandraSieveDAO.getScript(user, newName).thenApply(Optional::isPresent);
        CompletableFuture<Optional<Script>> oldScriptFuture = this.cassandraSieveDAO.getScript(user, oldName);
        oldScriptFuture.join();
        if (((Boolean)((CompletableFuture)scriptExistsFuture).join()).booleanValue()) {
            throw new DuplicateException();
        }
        this.performScriptRename(user, newName, oldScriptFuture.join().orElseThrow(ScriptNotFoundException::new));
    }

    private void performScriptRename(String user, String newName, Script oldScript) {
        CompletableFuture.allOf(this.cassandraSieveDAO.insertScript(user, Script.builder().copyOf(oldScript).name(newName).build()), this.cassandraSieveDAO.deleteScriptInCassandra(user, oldScript.getName()), this.performActiveScriptRename(user, oldScript.getName(), newName)).join();
    }

    private CompletableFuture<Void> performActiveScriptRename(String user, String oldName, String newName) {
        return this.cassandraActiveScriptDAO.getActiveSctiptInfo(user).thenCompose(optionalActivationInfo -> optionalActivationInfo.filter(activeScriptInfo -> activeScriptInfo.getName().equals(oldName)).map(name -> this.cassandraActiveScriptDAO.activate(user, newName)).orElse(CompletableFuture.completedFuture(null)));
    }

    public boolean hasQuota() {
        return this.cassandraSieveQuotaDAO.getQuota().join().isPresent();
    }

    public long getQuota() throws QuotaNotFoundException {
        return this.cassandraSieveQuotaDAO.getQuota().join().orElseThrow(QuotaNotFoundException::new);
    }

    public void setQuota(long quota) {
        this.cassandraSieveQuotaDAO.setQuota(quota).join();
    }

    public void removeQuota() throws QuotaNotFoundException {
        if (!this.cassandraSieveQuotaDAO.removeQuota().join().booleanValue()) {
            throw new QuotaNotFoundException();
        }
    }

    public boolean hasQuota(String user) {
        return (Boolean)((CompletableFuture)FluentFutureStream.ofFutures((CompletableFuture[])new CompletableFuture[]{this.cassandraSieveQuotaDAO.getQuota(user).thenApply(Optional::isPresent), this.cassandraSieveQuotaDAO.getQuota().thenApply(Optional::isPresent)}).reduce((b1, b2) -> b1 != false || b2 != false).thenApply(Optional::get)).join();
    }

    public long getQuota(String user) throws QuotaNotFoundException {
        return this.cassandraSieveQuotaDAO.getQuota(user).join().orElseThrow(QuotaNotFoundException::new);
    }

    public void setQuota(String user, long quota) {
        this.cassandraSieveQuotaDAO.setQuota(user, quota).join();
    }

    public void removeQuota(String user) throws QuotaNotFoundException {
        if (!this.cassandraSieveQuotaDAO.removeQuota(user).join().booleanValue()) {
            throw new QuotaNotFoundException();
        }
    }
}

