/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.sieve.cassandra.model;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.apache.james.sieverepository.api.exception.QuotaExceededException;

public class SieveQuota {
    private final long currentUsage;
    private final Optional<Long> limit;

    public SieveQuota(long currentUsage, Optional<Long> limit) {
        Preconditions.checkArgument((currentUsage >= 0L ? 1 : 0) != 0, (Object)"Current usage should be positive or equal to zero");
        limit.ifPresent(limitValue -> Preconditions.checkArgument((limitValue >= 0L ? 1 : 0) != 0, (Object)"Limit value should be positive or equal to zero"));
        this.currentUsage = currentUsage;
        this.limit = limit;
    }

    public void checkOverQuotaUponModification(long sizeDifference) throws QuotaExceededException {
        if (this.isExceededUponModification(sizeDifference)) {
            throw new QuotaExceededException();
        }
    }

    public boolean isExceededUponModification(long sizeDifference) {
        return this.limit.map(limitContent -> this.currentUsage + sizeDifference > limitContent).orElse(false);
    }
}

