/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Resource;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.utils.CassandraUtils;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.api.model.User;
import org.apache.james.user.lib.AbstractUsersRepository;
import org.apache.james.user.lib.model.DefaultUser;

public class CassandraUsersRepository
extends AbstractUsersRepository {
    private static final String DEFAULT_ALGO_VALUE = "SHA1";
    private Session session;

    @Inject
    @Resource
    public void setSession(Session session) {
        this.session = session;
    }

    public User getUserByName(String name) {
        ResultSet result = this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"realname", "passwd", "algorithm"}).from("user").where(QueryBuilder.eq((String)"name", (Object)name.toLowerCase(Locale.US))));
        return Optional.ofNullable(result.one()).map(row -> new DefaultUser(row.getString("realname"), row.getString("passwd"), row.getString("algorithm"))).filter(user -> user.getUserName().equals(name)).orElse(null);
    }

    public void updateUser(User user) throws UsersRepositoryException {
        Preconditions.checkArgument((boolean)(user instanceof DefaultUser));
        DefaultUser defaultUser = (DefaultUser)user;
        boolean executed = this.session.execute((Statement)QueryBuilder.update((String)"user").with(QueryBuilder.set((String)"realname", (Object)defaultUser.getUserName())).and(QueryBuilder.set((String)"passwd", (Object)defaultUser.getHashedPassword())).and(QueryBuilder.set((String)"algorithm", (Object)defaultUser.getHashAlgorithm())).where(QueryBuilder.eq((String)"name", (Object)defaultUser.getUserName().toLowerCase(Locale.US))).ifExists()).one().getBool(0);
        if (!executed) {
            throw new UsersRepositoryException("Unable to update user");
        }
    }

    public void removeUser(String name) throws UsersRepositoryException {
        boolean executed = this.session.execute((Statement)QueryBuilder.delete().from("user").where(QueryBuilder.eq((String)"name", (Object)name)).ifExists()).one().getBool(0);
        if (!executed) {
            throw new UsersRepositoryException("unable to remove unknown user " + name);
        }
    }

    public boolean contains(String name) {
        return this.getUserByName(name) != null;
    }

    public boolean test(String name, String password) throws UsersRepositoryException {
        return Optional.ofNullable(this.getUserByName(name)).map(x -> x.verifyPassword(password)).orElse(false);
    }

    public int countUsers() throws UsersRepositoryException {
        ResultSet result = this.session.execute((Statement)QueryBuilder.select().countAll().from("user"));
        return Ints.checkedCast((long)result.one().getLong(0));
    }

    public Iterator<String> list() throws UsersRepositoryException {
        ResultSet result = this.session.execute((Statement)QueryBuilder.select((String[])new String[]{"realname"}).from("user"));
        return CassandraUtils.convertToStream((ResultSet)result).map(row -> row.getString("realname")).iterator();
    }

    public void addUser(String username, String password) throws UsersRepositoryException {
        this.isValidUsername(username);
        this.doAddUser(username, password);
    }

    protected void doAddUser(String username, String password) throws UsersRepositoryException {
        DefaultUser user = new DefaultUser(username, DEFAULT_ALGO_VALUE);
        user.setPassword(password);
        boolean executed = this.session.execute((Statement)QueryBuilder.insertInto((String)"user").value("name", (Object)user.getUserName().toLowerCase(Locale.US)).value("realname", (Object)user.getUserName()).value("passwd", (Object)user.getHashedPassword()).value("algorithm", (Object)user.getHashAlgorithm()).ifNotExists()).one().getBool(0);
        if (!executed) {
            throw new AlreadyExistInUsersRepositoryException("User with username " + username + " already exist!");
        }
    }

    protected boolean getDefaultVirtualHostingValue() {
        return true;
    }
}

