/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.james.util.docker.RateLimiters;
import org.apache.james.util.docker.SwarmGenericContainer;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class LdapGenericContainer
extends ExternalResource {
    public static final int DEFAULT_LDAP_PORT = 389;
    private final SwarmGenericContainer container;

    public static Builder builder() {
        return new Builder();
    }

    private LdapGenericContainer(SwarmGenericContainer container) {
        this.container = container;
    }

    protected void before() {
        this.start();
    }

    protected void after() {
        this.stop();
    }

    public void start() {
        this.container.start();
    }

    public void stop() {
        this.container.stop();
    }

    public void pause() {
        this.container.pause();
    }

    public void unpause() {
        this.container.unpause();
    }

    public String getLdapHost() {
        return "ldap://" + this.container.getContainerIp() + ":" + 389;
    }

    public static class Builder {
        private String domain;
        private String password;

        private Builder() {
        }

        public Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public LdapGenericContainer build() {
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.domain) ? 1 : 0) != 0, (Object)"'domain' is mandatory");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.password) ? 1 : 0) != 0, (Object)"'password' is mandatory");
            return new LdapGenericContainer(this.createContainer());
        }

        private SwarmGenericContainer createContainer() {
            return new SwarmGenericContainer((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromClasspath("populate.ldif", "ldif-files/populate.ldif")).withFileFromClasspath("Dockerfile", "ldif-files/Dockerfile")).withAffinityToContainer().withEnv("SLAPD_DOMAIN", this.domain).withEnv("SLAPD_PASSWORD", this.password).withEnv("SLAPD_CONFIG_PASSWORD", this.password).withExposedPorts(new Integer[]{389}).waitingFor(new HostPortWaitStrategy().withRateLimiter(RateLimiters.TWENTIES_PER_SECOND));
        }
    }
}

