/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepositoryTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReadOnlyUsersLDAPRepositoryEmptyListTest {
    static LdapGenericContainer ldapContainer = LdapGenericContainer.builder().domain("james.org").password("mysecretpassword").build();
    DomainList domainList;
    private ReadOnlyUsersLDAPRepository ldapRepository;

    ReadOnlyUsersLDAPRepositoryEmptyListTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    private ReadOnlyUsersLDAPRepository startUsersRepository(HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfiguration) throws Exception {
        ReadOnlyUsersLDAPRepository ldapRepository = new ReadOnlyUsersLDAPRepository(this.domainList);
        ldapRepository.configure(ldapRepositoryConfiguration);
        ldapRepository.init();
        return ldapRepository;
    }

    @Nested
    class SupportVirtualHosting {
        SupportVirtualHosting() {
        }

        @BeforeEach
        void setUp() throws Exception {
            ReadOnlyUsersLDAPRepositoryEmptyListTest.this.domainList = (DomainList)Mockito.mock(DomainList.class);
            HierarchicalConfiguration<ImmutableNode> config = ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer);
            config.setProperty("[@userBase]", (Object)"ou=empty,dc=james,dc=org");
            ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository = ReadOnlyUsersLDAPRepositoryEmptyListTest.this.startUsersRepository((HierarchicalConfiguration<ImmutableNode>)config);
        }

        @Test
        void listShouldReturnEmptyWhenNoEntity() throws Exception {
            Assertions.assertThat((List)ImmutableList.copyOf((Iterator)ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository.list())).isEmpty();
        }

        @Test
        void countUsersShouldReturnZeroWhenEmptyRepository() throws UsersRepositoryException {
            int expected = 0;
            int actual = ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository.countUsers();
            Assertions.assertThat((int)actual).isEqualTo(expected);
        }
    }

    @Nested
    class WhenDisableVirtualHosting {
        WhenDisableVirtualHosting() {
        }

        @BeforeEach
        void setUp() throws Exception {
            ReadOnlyUsersLDAPRepositoryEmptyListTest.this.domainList = (DomainList)Mockito.mock(DomainList.class);
            HierarchicalConfiguration<ImmutableNode> config = ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer);
            config.setProperty("[@userBase]", (Object)"ou=empty,dc=james,dc=org");
            ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository = ReadOnlyUsersLDAPRepositoryEmptyListTest.this.startUsersRepository((HierarchicalConfiguration<ImmutableNode>)config);
        }

        @Test
        void listShouldReturnEmptyWhenNoEntity() throws Exception {
            Assertions.assertThat((List)ImmutableList.copyOf((Iterator)ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository.list())).isEmpty();
        }

        @Test
        void countUsersShouldReturnZeroWhenEmptyRepository() throws UsersRepositoryException {
            int expected = 0;
            int actual = ReadOnlyUsersLDAPRepositoryEmptyListTest.this.ldapRepository.countUsers();
            Assertions.assertThat((int)actual).isEqualTo(expected);
        }
    }
}

