/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConversionException;
import org.apache.commons.configuration2.plist.PropertyListConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.core.Username;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.mock.SimpleDomainList;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.ReadOnlyLDAPUsersDAO;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.user.lib.UsersRepositoryContract;
import org.apache.james.user.lib.UsersRepositoryImpl;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadOnlyUsersLDAPRepositoryTest {
    static final Logger LOGGER = LoggerFactory.getLogger(ReadOnlyUsersLDAPRepositoryTest.class);
    static final Username JAMES_USER_MAIL = Username.of((String)(DockerLdapSingleton.JAMES_USER.getLocalPart() + "@" + "james.org"));
    static final Username UNKNOWN = Username.of((String)"unknown");
    static final String BAD_PASSWORD = "badpassword";
    public static final String SUPPORTS_VIRTUAL_HOSTING = "supportsVirtualHosting";
    static LdapGenericContainer ldapContainer = LdapGenericContainer.builder().domain("james.org").password("mysecretpassword").build();

    ReadOnlyUsersLDAPRepositoryTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    private static ReadOnlyUsersLDAPRepository startUsersRepository(HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfiguration, DomainList domainList) throws Exception {
        ReadOnlyUsersLDAPRepository ldapRepository = new ReadOnlyUsersLDAPRepository(domainList);
        ldapRepository.configure(ldapRepositoryConfiguration);
        ldapRepository.init();
        return ldapRepository;
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfiguration(LdapGenericContainer ldapContainer) {
        PropertyListConfiguration configuration = ReadOnlyUsersLDAPRepositoryTest.baseConfiguration(ldapContainer);
        configuration.addProperty("[@userIdAttribute]", (Object)"uid");
        configuration.addProperty("[@administratorId]", (Object)"admin");
        return configuration;
    }

    static HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfigurationWithVirtualHosting(LdapGenericContainer ldapContainer) {
        PropertyListConfiguration configuration = ReadOnlyUsersLDAPRepositoryTest.baseConfiguration(ldapContainer);
        configuration.addProperty("[@userIdAttribute]", (Object)"mail");
        configuration.addProperty(SUPPORTS_VIRTUAL_HOSTING, (Object)true);
        configuration.addProperty("[@administratorId]", (Object)DockerLdapSingleton.ADMIN.asString());
        return configuration;
    }

    private static PropertyListConfiguration baseConfiguration(LdapGenericContainer ldapContainer) {
        PropertyListConfiguration configuration = new PropertyListConfiguration();
        configuration.addProperty("[@ldapHost]", (Object)ldapContainer.getLdapHost());
        configuration.addProperty("[@principal]", (Object)"cn=admin,dc=james,dc=org");
        configuration.addProperty("[@credentials]", (Object)"mysecretpassword");
        configuration.addProperty("[@userBase]", (Object)"ou=People,dc=james,dc=org");
        configuration.addProperty("[@userObjectClass]", (Object)"inetOrgPerson");
        configuration.addProperty("[@maxRetries]", (Object)"1");
        configuration.addProperty("[@retryStartInterval]", (Object)"0");
        configuration.addProperty("[@retryMaxInterval]", (Object)"2");
        configuration.addProperty("[@retryIntervalScale]", (Object)"100");
        configuration.addProperty("[@connectionTimeout]", (Object)"100");
        configuration.addProperty("[@readTimeout]", (Object)"100");
        return configuration;
    }

    @Nested
    class SupportVirtualHosting {
        SupportVirtualHosting() {
        }

        @Test
        void supportVirtualHostingShouldReturnFalseByDefault() throws Exception {
            ReadOnlyUsersLDAPRepository usersLDAPRepository = new ReadOnlyUsersLDAPRepository((DomainList)new SimpleDomainList());
            usersLDAPRepository.configure(ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer));
            Assertions.assertThat((boolean)usersLDAPRepository.supportVirtualHosting()).isFalse();
        }

        @Test
        void supportVirtualHostingShouldReturnTrueWhenReportedInConfig() throws Exception {
            HierarchicalConfiguration<ImmutableNode> configuration = ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer);
            configuration.addProperty(ReadOnlyUsersLDAPRepositoryTest.SUPPORTS_VIRTUAL_HOSTING, (Object)"true");
            ReadOnlyUsersLDAPRepository usersLDAPRepository = new ReadOnlyUsersLDAPRepository((DomainList)new SimpleDomainList());
            usersLDAPRepository.configure(configuration);
            Assertions.assertThat((boolean)usersLDAPRepository.supportVirtualHosting()).isTrue();
        }

        @Test
        void supportVirtualHostingShouldReturnFalseWhenReportedInConfig() throws Exception {
            HierarchicalConfiguration<ImmutableNode> configuration = ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer);
            configuration.addProperty(ReadOnlyUsersLDAPRepositoryTest.SUPPORTS_VIRTUAL_HOSTING, (Object)"false");
            ReadOnlyUsersLDAPRepository usersLDAPRepository = new ReadOnlyUsersLDAPRepository((DomainList)new SimpleDomainList());
            usersLDAPRepository.configure(configuration);
            Assertions.assertThat((boolean)usersLDAPRepository.supportVirtualHosting()).isFalse();
        }

        @Test
        void configureShouldThrowOnNonBooleanValueForSupportsVirtualHosting() {
            HierarchicalConfiguration<ImmutableNode> configuration = ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer);
            configuration.addProperty(ReadOnlyUsersLDAPRepositoryTest.SUPPORTS_VIRTUAL_HOSTING, (Object)"bad");
            ReadOnlyUsersLDAPRepository usersLDAPRepository = new ReadOnlyUsersLDAPRepository((DomainList)new SimpleDomainList());
            Assertions.assertThatThrownBy(() -> usersLDAPRepository.configure(configuration)).isInstanceOf(ConversionException.class);
        }
    }

    @Nested
    class WhenDisableVirtualHosting
    implements UsersRepositoryContract.WithOutVirtualHostingReadOnlyContract {
        @RegisterExtension
        UsersRepositoryContract.UserRepositoryExtension extension = UsersRepositoryContract.UserRepositoryExtension.withoutVirtualHosting();
        private ReadOnlyUsersLDAPRepository usersRepository;

        WhenDisableVirtualHosting() {
        }

        @BeforeEach
        void setUp(UsersRepositoryContract.TestSystem testSystem) throws Exception {
            this.usersRepository = ReadOnlyUsersLDAPRepositoryTest.startUsersRepository((HierarchicalConfiguration<ImmutableNode>)ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfiguration(ldapContainer), (DomainList)testSystem.getDomainList());
        }

        public UsersRepositoryImpl<ReadOnlyLDAPUsersDAO> testee() {
            return this.usersRepository;
        }

        @Test
        void knownUserShouldBeAbleToLogInWhenPasswordIsCorrect() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(DockerLdapSingleton.JAMES_USER, "secret")).isTrue();
        }

        @Test
        void knownUserShouldNotBeAbleToLogInWhenPasswordIsNotCorrect() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(DockerLdapSingleton.JAMES_USER, ReadOnlyUsersLDAPRepositoryTest.BAD_PASSWORD)).isFalse();
        }

        @Test
        void unknownUserShouldNotBeAbleToLogIn() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(UNKNOWN, ReadOnlyUsersLDAPRepositoryTest.BAD_PASSWORD)).isFalse();
        }

        @Test
        void unknownUserShouldNotBeAbleToLogInWhenPasswordIsCorrect() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(UNKNOWN, "secret")).isFalse();
        }

        @Test
        void containsWithGetUserShouldBeTrue() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.contains(this.usersRepository.getUsername(JAMES_USER_MAIL.asMailAddress()))).isTrue();
        }

        @Test
        void isAdministratorShouldReturnTrueWhenConfiguredAndUserIsAdmin(UsersRepositoryContract.TestSystem testSystem) throws Exception {
            Assertions.assertThat((boolean)this.testee().isAdministrator(testSystem.getAdmin())).isTrue();
        }

        @Disabled(value="JAMES-3088 Users are provisioned by default from Dockerfile, cannot setup this test case,See @link{ReadOnlyUsersLDAPRepositoryEmptyListTest}")
        @Test
        public void listShouldReturnEmptyIteratorWhenEmptyRepository(UsersRepositoryContract.TestSystem testSystem) {
        }

        @Disabled(value="JAMES-3088 Users are provisioned by default from Dockerfile, cannot setup this test case,See @link{ReadOnlyUsersLDAPRepositoryEmptyListTest}")
        @Test
        public void countUsersShouldReturnZeroWhenEmptyRepository() {
        }
    }

    @Nested
    class WhenEnableVirtualHosting
    implements UsersRepositoryContract.WithVirtualHostingReadOnlyContract {
        @RegisterExtension
        UsersRepositoryContract.UserRepositoryExtension extension = UsersRepositoryContract.UserRepositoryExtension.withVirtualHost();
        private ReadOnlyUsersLDAPRepository usersRepository;

        WhenEnableVirtualHosting() {
        }

        @BeforeEach
        void setUp(UsersRepositoryContract.TestSystem testSystem) throws Exception {
            this.usersRepository = ReadOnlyUsersLDAPRepositoryTest.startUsersRepository((HierarchicalConfiguration<ImmutableNode>)ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer), (DomainList)testSystem.getDomainList());
        }

        public UsersRepositoryImpl<ReadOnlyLDAPUsersDAO> testee() {
            return this.usersRepository;
        }

        @Test
        void isAdministratorShouldReturnTrueWhenConfiguredAndUserIsAdmin(UsersRepositoryContract.TestSystem testSystem) throws Exception {
            Assertions.assertThat((boolean)this.testee().isAdministrator(testSystem.getAdmin())).isTrue();
        }

        @Test
        void knownUserShouldBeAbleToLogInWhenPasswordIsCorrectWithVirtualHosting() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(JAMES_USER_MAIL, "secret")).isTrue();
        }

        @Test
        void testShouldStillWorkAfterRestartingLDAP() throws Exception {
            this.usersRepository.test(JAMES_USER_MAIL, "secret");
            DockerLdapSingleton.ldapContainer.pause();
            try {
                this.usersRepository.test(JAMES_USER_MAIL, "secret");
            }
            catch (Exception e) {
                LOGGER.info("This exception is expected as we shut down the LDAP and forced its use", (Throwable)e);
            }
            DockerLdapSingleton.ldapContainer.unpause();
            Assertions.assertThat((boolean)this.usersRepository.test(JAMES_USER_MAIL, "secret")).isTrue();
        }

        @Test
        void knownUserShouldNotBeAbleToLogInWhenPasswordIsNotCorrectWithVirtualHosting() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(DockerLdapSingleton.JAMES_USER, ReadOnlyUsersLDAPRepositoryTest.BAD_PASSWORD)).isFalse();
        }

        @Test
        void unknownUserShouldNotBeAbleToLogInWhenPasswordIsCorrectWithVirtualHosting() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.test(UNKNOWN, "secret")).isFalse();
        }

        @Test
        void specialCharacterInUserInputShouldBeSanitized() throws Exception {
            Username patternMatchingMultipleUsers = Username.of((String)"j*");
            Assertions.assertThat((boolean)this.usersRepository.test(patternMatchingMultipleUsers, "secret")).isFalse();
        }

        @Test
        void containsWithGetUserShouldBeTrueWithVirtualHosting() throws Exception {
            Assertions.assertThat((boolean)this.usersRepository.contains(this.usersRepository.getUsername(JAMES_USER_MAIL.asMailAddress()))).isTrue();
        }

        @Disabled(value="JAMES-3088 Users are provisioned by default from Dockerfile, cannot setup this test case,See @link{ReadOnlyUsersLDAPRepositoryEmptyListTest}")
        @Test
        public void listShouldReturnEmptyIteratorWhenEmptyRepository(UsersRepositoryContract.TestSystem testSystem) {
        }

        @Disabled(value="JAMES-3088 Users are provisioned by default from Dockerfile, cannot setup this test case,See @link{ReadOnlyUsersLDAPRepositoryEmptyListTest}")
        @Test
        public void countUsersShouldReturnZeroWhenEmptyRepository() {
        }
    }
}

