/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import org.apache.james.core.healthcheck.Result;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.mock.SimpleDomainList;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.LdapHealthCheck;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepositoryTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class LdapHealthCheckTest {
    static LdapGenericContainer ldapContainer = LdapGenericContainer.builder().domain("james.org").password("mysecretpassword").build();
    LdapHealthCheck ldapHealthCheck;

    LdapHealthCheckTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    @BeforeEach
    public void setUp() throws Exception {
        ReadOnlyUsersLDAPRepository ldapUserRepository = new ReadOnlyUsersLDAPRepository((DomainList)new SimpleDomainList());
        ldapUserRepository.configure(ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer));
        ldapUserRepository.init();
        this.ldapHealthCheck = new LdapHealthCheck(ldapUserRepository);
    }

    @Test
    void checkShouldReturnUnhealthyIfLdapIsDown() {
        ldapContainer.pause();
        try {
            Result checkResult = (Result)this.ldapHealthCheck.check().block();
            Assertions.assertThat((boolean)checkResult.isUnHealthy()).isTrue();
        }
        finally {
            ldapContainer.unpause();
        }
    }

    @Test
    void checkShouldReturnHealthyIfLdapIsRunning() {
        Result checkResult = (Result)this.ldapHealthCheck.check().block();
        Assertions.assertThat((boolean)checkResult.isHealthy()).isTrue();
    }
}

