/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.user.ldap;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.user.ldap.DockerLdapSingleton;
import org.apache.james.user.ldap.LdapGenericContainer;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepository;
import org.apache.james.user.ldap.ReadOnlyUsersLDAPRepositoryTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class ReadOnlyUsersLDAPRepositoryInvalidDnTest {
    static LdapGenericContainer ldapContainer = LdapGenericContainer.builder().dockerFilePrefix("invalid/").domain("james.org").password("mysecretpassword").build();
    DomainList domainList;
    private ReadOnlyUsersLDAPRepository ldapRepository;

    ReadOnlyUsersLDAPRepositoryInvalidDnTest() {
    }

    @BeforeAll
    static void setUpAll() {
        ldapContainer.start();
    }

    @AfterAll
    static void afterAll() {
        ldapContainer.stop();
    }

    @BeforeEach
    void setUp() throws Exception {
        this.domainList = (DomainList)Mockito.mock(DomainList.class);
        this.ldapRepository = this.startUsersRepository(ReadOnlyUsersLDAPRepositoryTest.ldapRepositoryConfigurationWithVirtualHosting(ldapContainer));
    }

    @Test
    void listShouldFilterOutUsersWithoutIdField() throws Exception {
        Assertions.assertThat((List)ImmutableList.copyOf((Iterator)this.ldapRepository.list())).isEmpty();
    }

    @Test
    void getUserByNameShouldReturnNullWhenNoIdField() throws Exception {
        Assertions.assertThat((Object)this.ldapRepository.getUserByName(DockerLdapSingleton.JAMES_USER)).isNull();
    }

    @Test
    void containsShouldReturnFalseWhenNoIdField() throws Exception {
        Assertions.assertThat((boolean)this.ldapRepository.contains(DockerLdapSingleton.JAMES_USER)).isFalse();
    }

    @Test
    void contShouldReturnZeroWhenInvalidUser() throws Exception {
        Assertions.assertThat((int)this.ldapRepository.countUsers()).isEqualTo(0);
    }

    private ReadOnlyUsersLDAPRepository startUsersRepository(HierarchicalConfiguration<ImmutableNode> ldapRepositoryConfiguration) throws Exception {
        ReadOnlyUsersLDAPRepository ldapRepository = new ReadOnlyUsersLDAPRepository(this.domainList);
        ldapRepository.configure(ldapRepositoryConfiguration);
        ldapRepository.init();
        return ldapRepository;
    }
}

