/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.fetchmail;

import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.james.fetchmail.Account;
import org.apache.james.fetchmail.MessageProcessor;
import org.apache.james.fetchmail.ProcessorAbstract;

public class FolderProcessor
extends ProcessorAbstract {
    private Folder fieldFolder;
    private Boolean fieldMarkSeenPermanent;

    protected FolderProcessor(Folder folder, Account account) {
        super(account);
        this.setFolder(folder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() throws MessagingException {
        int messagesProcessed = 0;
        int messageCount = 0;
        try {
            try {
                this.open();
            }
            catch (MessagingException ex) {
                this.getLogger().error(this.getFetchTaskName() + " Failed to open folder!");
                throw ex;
            }
            Folder ex = this.getFolder();
            synchronized (ex) {
                messageCount = this.getFolder().getMessageCount();
                for (int i = 1; i <= messageCount; ++i) {
                    MimeMessage message = (MimeMessage)this.getFolder().getMessage(i);
                    if (!this.isFetchAll() && this.isSeen(message)) continue;
                    try {
                        new MessageProcessor(message, this.getAccount()).process();
                        ++messagesProcessed;
                        continue;
                    }
                    catch (Exception ex2) {
                        StringBuilder logMessageBuffer = new StringBuilder("Exception processing message ID: ");
                        logMessageBuffer.append(message.getMessageID());
                        this.getLogger().error(logMessageBuffer.toString(), (Throwable)ex2);
                    }
                }
            }
        }
        catch (MessagingException mex) {
            this.getLogger().error("A MessagingException has terminated fetching messages for this folder", (Throwable)mex);
        }
        finally {
            try {
                this.close();
            }
            catch (MessagingException mex) {}
            StringBuilder logMessageBuffer = new StringBuilder("Processed ");
            logMessageBuffer.append(messagesProcessed);
            logMessageBuffer.append(" messages of ");
            logMessageBuffer.append(messageCount);
            logMessageBuffer.append(" in folder '");
            logMessageBuffer.append(this.getFolder().getName());
            logMessageBuffer.append("'");
            this.getLogger().info(logMessageBuffer.toString());
        }
        try {
            if (this.isRecurse()) {
                this.recurse();
            }
        }
        catch (MessagingException mex) {
            this.getLogger().error("A MessagingException has terminated recursing through sub-folders", (Throwable)mex);
        }
    }

    protected void close() throws MessagingException {
        if (null != this.getFolder() && this.getFolder().isOpen()) {
            this.getFolder().close(true);
        }
    }

    protected void recurse() throws MessagingException {
        if ((this.getFolder().getType() & 2) == 2) {
            Folder[] folders;
            for (Folder folder : folders = this.getFolder().list()) {
                new FolderProcessor(folder, this.getAccount()).process();
            }
        }
    }

    protected void open() throws MessagingException {
        int openFlag = 2;
        if (this.isOpenReadOnly()) {
            openFlag = 1;
        }
        this.getFolder().open(openFlag);
    }

    protected Folder getFolder() {
        return this.fieldFolder;
    }

    protected boolean isSeen(MimeMessage aMessage) throws MessagingException {
        boolean isSeen = this.isMarkSeenPermanent() != false ? aMessage.isSet(Flags.Flag.SEEN) : this.handleMarkSeenNotPermanent(aMessage);
        return isSeen;
    }

    protected Boolean computeMarkSeenPermanent() {
        return this.getFolder().getPermanentFlags().contains(Flags.Flag.SEEN);
    }

    protected boolean handleMarkSeenNotPermanent(MimeMessage aMessage) throws MessagingException {
        return aMessage.isSet(Flags.Flag.SEEN);
    }

    protected void setFolder(Folder folder) {
        this.fieldFolder = folder;
    }

    protected Boolean isMarkSeenPermanent() {
        Boolean markSeenPermanent = this.isMarkSeenPermanentBasic();
        if (null == markSeenPermanent) {
            this.updateMarkSeenPermanent();
            return this.isMarkSeenPermanent();
        }
        return markSeenPermanent;
    }

    private Boolean isMarkSeenPermanentBasic() {
        return this.fieldMarkSeenPermanent;
    }

    protected void setMarkSeenPermanent(Boolean markSeenPermanent) {
        this.fieldMarkSeenPermanent = markSeenPermanent;
    }

    protected void updateMarkSeenPermanent() {
        this.setMarkSeenPermanent(this.computeMarkSeenPermanent());
    }
}

