/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.ProvidesIntoSet;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.apache.james.jmap.draft.JMAPConfigurationStartUpCheck;
import org.apache.james.jmap.draft.api.AccessTokenManager;
import org.apache.james.jmap.draft.api.SimpleTokenFactory;
import org.apache.james.jmap.draft.api.SimpleTokenManager;
import org.apache.james.jmap.draft.crypto.AccessTokenManagerImpl;
import org.apache.james.jmap.draft.crypto.JamesSignatureHandler;
import org.apache.james.jmap.draft.crypto.SecurityKeyLoader;
import org.apache.james.jmap.draft.crypto.SignatureHandler;
import org.apache.james.jmap.draft.crypto.SignedTokenFactory;
import org.apache.james.jmap.draft.crypto.SignedTokenManager;
import org.apache.james.jmap.draft.model.MailboxFactory;
import org.apache.james.jmap.draft.model.message.view.MessageFastViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageFullViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageHeaderViewFactory;
import org.apache.james.jmap.draft.model.message.view.MessageMetadataViewFactory;
import org.apache.james.jmap.draft.send.MailSpool;
import org.apache.james.jmap.event.ComputeMessageFastViewProjectionListener;
import org.apache.james.jmap.http.AccessTokenAuthenticationStrategy;
import org.apache.james.jmap.http.AuthenticationStrategy;
import org.apache.james.jmap.http.JWTAuthenticationStrategy;
import org.apache.james.jmap.http.QueryParameterAccessTokenAuthenticationStrategy;
import org.apache.james.lifecycle.api.StartUpCheck;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.util.date.DefaultZonedDateTimeProvider;
import org.apache.james.util.date.ZonedDateTimeProvider;
import org.apache.james.util.mime.MessageContentExtractor;
import org.apache.james.utils.InitializationOperation;
import org.apache.james.utils.InitilizationOperationBuilder;
import org.apache.mailet.base.AutomaticallySentMailDetector;
import org.apache.mailet.base.AutomaticallySentMailDetectorImpl;

public class JMAPCommonModule
extends AbstractModule {
    private static final long DEFAULT_TOKEN_EXPIRATION_IN_MS = TimeUnit.MILLISECONDS.convert(15L, TimeUnit.MINUTES);

    protected void configure() {
        this.bind(JamesSignatureHandler.class).in(Scopes.SINGLETON);
        this.bind(DefaultZonedDateTimeProvider.class).in(Scopes.SINGLETON);
        this.bind(SignedTokenManager.class).in(Scopes.SINGLETON);
        this.bind(AccessTokenManagerImpl.class).in(Scopes.SINGLETON);
        this.bind(MailSpool.class).in(Scopes.SINGLETON);
        this.bind(AutomaticallySentMailDetectorImpl.class).in(Scopes.SINGLETON);
        this.bind(MailboxFactory.class).in(Scopes.SINGLETON);
        this.bind(MessageFullViewFactory.class).in(Scopes.SINGLETON);
        this.bind(MessageMetadataViewFactory.class).in(Scopes.SINGLETON);
        this.bind(MessageHeaderViewFactory.class).in(Scopes.SINGLETON);
        this.bind(MessageFastViewFactory.class).in(Scopes.SINGLETON);
        this.bind(MessageContentExtractor.class).in(Scopes.SINGLETON);
        this.bind(SecurityKeyLoader.class).in(Scopes.SINGLETON);
        this.bind(SignatureHandler.class).to(JamesSignatureHandler.class);
        this.bind(ZonedDateTimeProvider.class).to(DefaultZonedDateTimeProvider.class);
        this.bind(SimpleTokenManager.class).to(SignedTokenManager.class);
        this.bind(SimpleTokenFactory.class).to(SignedTokenFactory.class);
        this.bind(AutomaticallySentMailDetector.class).to(AutomaticallySentMailDetectorImpl.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"tokenExpirationInMs")).to(DEFAULT_TOKEN_EXPIRATION_IN_MS);
        this.bind(AccessTokenManager.class).to(AccessTokenManagerImpl.class);
        Multibinder.newSetBinder((Binder)this.binder(), MailboxListener.GroupMailboxListener.class).addBinding().to(ComputeMessageFastViewProjectionListener.class);
        Multibinder.newSetBinder((Binder)this.binder(), StartUpCheck.class).addBinding().to(JMAPConfigurationStartUpCheck.class);
    }

    @Provides
    @Singleton
    public List<AuthenticationStrategy> authStrategies(AccessTokenAuthenticationStrategy accessTokenAuthenticationStrategy, JWTAuthenticationStrategy jwtAuthenticationStrategy, QueryParameterAccessTokenAuthenticationStrategy queryParameterAuthenticationStrategy) {
        return ImmutableList.of((Object)jwtAuthenticationStrategy, (Object)accessTokenAuthenticationStrategy, (Object)queryParameterAuthenticationStrategy);
    }

    @ProvidesIntoSet
    InitializationOperation workQueue(MailSpool instance) {
        return InitilizationOperationBuilder.forClass(MailSpool.class).init(() -> ((MailSpool)instance).start());
    }
}

