/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft;

import java.util.Arrays;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPServer;
import org.apache.james.jmap.api.projections.MessageFastViewProjection;
import org.apache.james.jmap.api.vacation.AccountId;
import org.apache.james.jmap.api.vacation.Vacation;
import org.apache.james.jmap.api.vacation.VacationPatch;
import org.apache.james.jmap.api.vacation.VacationRepository;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageIdManager;
import org.apache.james.mailbox.events.EventBus;
import org.apache.james.mailbox.events.MailboxListener;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.util.Port;
import org.apache.james.utils.GuiceProbe;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class JmapGuiceProbe
implements GuiceProbe {
    private final VacationRepository vacationRepository;
    private final JMAPServer jmapServer;
    private final MessageIdManager messageIdManager;
    private final MailboxManager mailboxManager;
    private final EventBus eventBus;
    private final MessageFastViewProjection messageFastViewProjection;

    @Inject
    private JmapGuiceProbe(VacationRepository vacationRepository, JMAPServer jmapServer, MessageIdManager messageIdManager, MailboxManager mailboxManager, EventBus eventBus, MessageFastViewProjection messageFastViewProjection) {
        this.vacationRepository = vacationRepository;
        this.jmapServer = jmapServer;
        this.messageIdManager = messageIdManager;
        this.mailboxManager = mailboxManager;
        this.eventBus = eventBus;
        this.messageFastViewProjection = messageFastViewProjection;
    }

    public Port getJmapPort() {
        return this.jmapServer.getPort();
    }

    public void addMailboxListener(MailboxListener.GroupMailboxListener listener) {
        this.eventBus.register(listener);
    }

    public void modifyVacation(AccountId accountId, VacationPatch vacationPatch) {
        this.vacationRepository.modifyVacation(accountId, vacationPatch).block();
    }

    public Vacation retrieveVacation(AccountId accountId) {
        return (Vacation)this.vacationRepository.retrieveVacation(accountId).block();
    }

    public void setInMailboxes(MessageId messageId, Username username, MailboxId ... mailboxIds) throws MailboxException {
        MailboxSession mailboxSession = this.mailboxManager.createSystemSession(username);
        this.messageIdManager.setInMailboxes(messageId, Arrays.asList(mailboxIds), mailboxSession);
    }

    public void clearMessageFastViewProjection() {
        Mono.from((Publisher)this.messageFastViewProjection.clear()).block();
    }
}

