/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;

public class JPAConfiguration {
    private final String driverName;
    private final String driverURL;
    private final boolean testOnBorrow;
    private final int validationQueryTimeoutSec;
    private final String validationQuery;

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    JPAConfiguration(String driverName, String driverURL, boolean testOnBorrow, int validationQueryTimeoutSec, String validationQuery) {
        this.driverName = driverName;
        this.driverURL = driverURL;
        this.testOnBorrow = testOnBorrow;
        this.validationQueryTimeoutSec = validationQueryTimeoutSec;
        this.validationQuery = validationQuery;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getDriverURL() {
        return this.driverURL;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public int getValidationQueryTimeoutSec() {
        return this.validationQueryTimeoutSec;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public static class Builder {
        private String driverName;
        private String driverURL;
        private boolean testOnBorrow;
        private int validationQueryTimeoutSec = -1;
        private String validationQuery;

        public Builder driverName(String driverName) {
            this.driverName = driverName;
            return this;
        }

        public Builder driverURL(String driverURL) {
            this.driverURL = driverURL;
            return this;
        }

        public Builder testOnBorrow(boolean testOnBorrow) {
            this.testOnBorrow = testOnBorrow;
            return this;
        }

        public Builder validationQueryTimeoutSec(int validationQueryTimeoutSec) {
            this.validationQueryTimeoutSec = validationQueryTimeoutSec;
            return this;
        }

        public Builder validationQuery(String validationQuery) {
            this.validationQuery = validationQuery;
            return this;
        }

        public JPAConfiguration build() {
            Preconditions.checkNotNull((Object)this.driverName);
            Preconditions.checkNotNull((Object)this.driverURL);
            return new JPAConfiguration(this.driverName, this.driverURL, this.testOnBorrow, this.validationQueryTimeoutSec, this.validationQuery);
        }
    }
}

