/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.jpa.JPADomainList;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.ConfigurationPerformer;

public class JPADomainListModule
extends AbstractModule {
    public void configure() {
        this.bind(JPADomainList.class).in(Scopes.SINGLETON);
        this.bind(DomainList.class).to(JPADomainList.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigurationPerformer.class).addBinding().to(JPADomainListConfigurationPerformer.class);
    }

    @Singleton
    public static class JPADomainListConfigurationPerformer
    implements ConfigurationPerformer {
        private final ConfigurationProvider configurationProvider;
        private final JPADomainList jpaDomainList;

        @Inject
        public JPADomainListConfigurationPerformer(ConfigurationProvider configurationProvider, JPADomainList jpaDomainList) {
            this.configurationProvider = configurationProvider;
            this.jpaDomainList = jpaDomainList;
        }

        public void initModule() {
            try {
                this.jpaDomainList.configure(this.configurationProvider.getConfiguration("domainlist"));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Class<? extends Configurable>> forClasses() {
            return ImmutableList.of(JPADomainList.class);
        }
    }
}

