/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.base.Joiner;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.inject.Singleton;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.james.modules.data.JPAConfiguration;
import org.apache.james.utils.PropertiesProvider;

public class JPAEntityManagerModule
extends AbstractModule {
    protected void configure() {
    }

    @Provides
    @Singleton
    public EntityManagerFactory provideEntityManagerFactory(JPAConfiguration jpaConfiguration) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("openjpa.ConnectionDriverName", jpaConfiguration.getDriverName());
        properties.put("openjpa.ConnectionURL", jpaConfiguration.getDriverURL());
        ArrayList<String> connectionFactoryProperties = new ArrayList<String>();
        connectionFactoryProperties.add("TestOnBorrow=" + jpaConfiguration.isTestOnBorrow());
        if (jpaConfiguration.getValidationQueryTimeoutSec() > 0) {
            connectionFactoryProperties.add("ValidationTimeout=" + jpaConfiguration.getValidationQueryTimeoutSec() * 1000);
        }
        if (jpaConfiguration.getValidationQuery() != null) {
            connectionFactoryProperties.add("ValidationSQL='" + jpaConfiguration.getValidationQuery() + "'");
        }
        properties.put("openjpa.ConnectionFactoryProperties", Joiner.on((String)", ").join(connectionFactoryProperties));
        return Persistence.createEntityManagerFactory((String)"Global", properties);
    }

    @Provides
    @Singleton
    JPAConfiguration provideConfiguration(PropertiesProvider propertiesProvider) throws FileNotFoundException, ConfigurationException {
        PropertiesConfiguration dataSource = propertiesProvider.getConfiguration("james-database");
        return JPAConfiguration.builder().driverName(dataSource.getString("database.driverClassName")).driverURL(dataSource.getString("database.url")).testOnBorrow(dataSource.getBoolean("datasource.testOnBorrow", false)).validationQueryTimeoutSec(dataSource.getInt("datasource.validationQueryTimeoutSec", -1)).validationQuery(dataSource.getString("datasource.validationQuery", null)).build();
    }
}

