/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.rrt.api.RecipientRewriteTable;
import org.apache.james.rrt.jpa.JPARecipientRewriteTable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.utils.ConfigurationPerformer;

public class JPARecipientRewriteTableModule
extends AbstractModule {
    public void configure() {
        this.bind(JPARecipientRewriteTable.class).in(Scopes.SINGLETON);
        this.bind(RecipientRewriteTable.class).to(JPARecipientRewriteTable.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigurationPerformer.class).addBinding().to(JPARecipientRewriteTablePerformer.class);
    }

    @Singleton
    public static class JPARecipientRewriteTablePerformer
    implements ConfigurationPerformer {
        private final ConfigurationProvider configurationProvider;
        private final JPARecipientRewriteTable recipientRewriteTable;

        @Inject
        public JPARecipientRewriteTablePerformer(ConfigurationProvider configurationProvider, JPARecipientRewriteTable recipientRewriteTable) {
            this.configurationProvider = configurationProvider;
            this.recipientRewriteTable = recipientRewriteTable;
        }

        public void initModule() {
            try {
                this.recipientRewriteTable.configure(this.configurationProvider.getConfiguration("recipientrewritetable"));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Class<? extends Configurable>> forClasses() {
            return ImmutableList.of(JPARecipientRewriteTable.class);
        }
    }
}

