/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.modules.data;

import com.google.common.collect.ImmutableList;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import java.util.List;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.james.lifecycle.api.Configurable;
import org.apache.james.server.core.configuration.ConfigurationProvider;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.jpa.JPAUsersRepository;
import org.apache.james.utils.ConfigurationPerformer;

public class JPAUsersRepositoryModule
extends AbstractModule {
    public void configure() {
        this.bind(JPAUsersRepository.class).in(Scopes.SINGLETON);
        this.bind(UsersRepository.class).to(JPAUsersRepository.class);
        Multibinder.newSetBinder((Binder)this.binder(), ConfigurationPerformer.class).addBinding().to(JPAUsersRepositoryConfigurationPerformer.class);
    }

    @Singleton
    public static class JPAUsersRepositoryConfigurationPerformer
    implements ConfigurationPerformer {
        private final ConfigurationProvider configurationProvider;
        private final JPAUsersRepository usersRepository;

        @Inject
        public JPAUsersRepositoryConfigurationPerformer(ConfigurationProvider configurationProvider, JPAUsersRepository usersRepository) {
            this.configurationProvider = configurationProvider;
            this.usersRepository = usersRepository;
        }

        public void initModule() {
            try {
                this.usersRepository.configure(this.configurationProvider.getConfiguration("usersrepository"));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }

        public List<Class<? extends Configurable>> forClasses() {
            return ImmutableList.of(JPAUsersRepository.class);
        }
    }
}

