/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq;

import javax.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.blob.BlobTransferPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopGaugeRegistry;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.activemq.ActiveMQMailQueueBlobTest;
import org.apache.james.queue.activemq.ActiveMQMailQueueFactory;
import org.apache.james.queue.activemq.FileSystemBlobTransferPolicy;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueFactoryContract;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.ManageableMailQueueFactoryContract;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.jms.BrokerExtension;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.extension.ExtendWith;

public class ActiveMQMailQueueFactoryTest {

    @Nested
    @ExtendWith(value={BrokerExtension.class})
    public static class ActiveMQMailQueueFactoryBlobsTest
    implements MailQueueFactoryContract<ManageableMailQueue>,
    ManageableMailQueueFactoryContract {
        static final String BASE_DIR = "file://target/james-test";
        ActiveMQMailQueueFactory mailQueueFactory;
        ActiveMQMailQueueBlobTest.MyFileSystem fileSystem;

        @BeforeEach
        public void setUp(BrokerService brokerService) {
            this.fileSystem = new ActiveMQMailQueueBlobTest.MyFileSystem();
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
            FileSystemBlobTransferPolicy policy = new FileSystemBlobTransferPolicy();
            policy.setFileSystem((FileSystem)this.fileSystem);
            policy.setDefaultUploadUrl(BASE_DIR);
            connectionFactory.setBlobTransferPolicy((BlobTransferPolicy)policy);
            RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
            RecordingMetricFactory metricFactory = new RecordingMetricFactory();
            NoopGaugeRegistry gaugeRegistry = new NoopGaugeRegistry();
            this.mailQueueFactory = new ActiveMQMailQueueFactory((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, (MetricFactory)metricFactory, (GaugeRegistry)gaugeRegistry);
            this.mailQueueFactory.setUseJMX(false);
            this.mailQueueFactory.setUseBlobMessages(true);
        }

        @AfterEach
        public void tearDown() throws Exception {
            this.mailQueueFactory.destroy();
            this.fileSystem.destroy();
        }

        public MailQueueFactory<ManageableMailQueue> getMailQueueFactory() {
            return this.mailQueueFactory;
        }
    }

    @Nested
    @ExtendWith(value={BrokerExtension.class})
    public static class ActiveMQMailQueueFactoryNoBlobsTest
    implements MailQueueFactoryContract<ManageableMailQueue>,
    ManageableMailQueueFactoryContract {
        ActiveMQMailQueueFactory mailQueueFactory;

        @BeforeEach
        public void setUp(BrokerService brokerService) {
            ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
            RawMailQueueItemDecoratorFactory mailQueueItemDecoratorFactory = new RawMailQueueItemDecoratorFactory();
            RecordingMetricFactory metricFactory = new RecordingMetricFactory();
            NoopGaugeRegistry gaugeRegistry = new NoopGaugeRegistry();
            this.mailQueueFactory = new ActiveMQMailQueueFactory((ConnectionFactory)connectionFactory, (MailQueueItemDecoratorFactory)mailQueueItemDecoratorFactory, (MetricFactory)metricFactory, (GaugeRegistry)gaugeRegistry);
            this.mailQueueFactory.setUseJMX(false);
            this.mailQueueFactory.setUseBlobMessages(false);
        }

        @AfterEach
        public void tearDown() {
            this.mailQueueFactory.destroy();
        }

        public MailQueueFactory<ManageableMailQueue> getMailQueueFactory() {
            return this.mailQueueFactory;
        }
    }
}

