/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq.metric;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.ActiveMQPrefetchPolicy;
import org.apache.activemq.broker.BrokerService;
import org.apache.james.metrics.api.Gauge;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopGaugeRegistry;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.activemq.ActiveMQConfiguration;
import org.apache.james.queue.activemq.metric.ActiveMQMetricCollectorImpl;
import org.apache.james.queue.activemq.metric.ActiveMQMetrics;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.jms.BrokerExtension;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ExtendWith(value={BrokerExtension.class})
@Tag(value="Statistics")
class ActiveMQMetricCollectorTest {
    private static ActiveMQConnectionFactory connectionFactory;
    private static final ActiveMQConfiguration EMPTY_CONFIGURATION;

    ActiveMQMetricCollectorTest() {
    }

    @BeforeAll
    static void setup(BrokerService broker) {
        connectionFactory = new ActiveMQConnectionFactory("vm://localhost?create=false");
        ActiveMQPrefetchPolicy prefetchPolicy = new ActiveMQPrefetchPolicy();
        prefetchPolicy.setQueuePrefetch(0);
        connectionFactory.setPrefetchPolicy(prefetchPolicy);
    }

    @Test
    void shouldFailToFetchAndUpdateStatisticsForUnknownQueue() {
        SimpleGaugeRegistry gaugeRegistry = new SimpleGaugeRegistry();
        ActiveMQMetricCollectorImpl testee = new ActiveMQMetricCollectorImpl(EMPTY_CONFIGURATION, (ConnectionFactory)connectionFactory, (MetricFactory)new RecordingMetricFactory(), (GaugeRegistry)gaugeRegistry);
        ActiveMQMetrics queueStatistics = ActiveMQMetrics.forQueue((String)"UNKNOWN", (GaugeRegistry)gaugeRegistry);
        Assertions.assertThatThrownBy(() -> testee.fetchAndUpdate(queueStatistics)).isInstanceOf(JMSException.class);
        Assertions.assertThat((Object)gaugeRegistry.getGauge("ActiveMQ.Statistics.Destination.UNKNOWN")).isNull();
    }

    @Test
    void shouldFetchAndUpdateBrokerStatistics() throws Exception {
        SimpleGaugeRegistry gaugeRegistry = new SimpleGaugeRegistry();
        ActiveMQMetricCollectorImpl testee = new ActiveMQMetricCollectorImpl(EMPTY_CONFIGURATION, (ConnectionFactory)connectionFactory, (MetricFactory)new RecordingMetricFactory(), (GaugeRegistry)gaugeRegistry);
        ActiveMQMetrics brokerStatistics = ActiveMQMetrics.forBroker((GaugeRegistry)gaugeRegistry);
        long notBefore = System.currentTimeMillis();
        testee.fetchAndUpdate(brokerStatistics);
        Number n = gaugeRegistry.getGauge("ActiveMQ.Statistics.Broker.lastUpdate");
        Assertions.assertThat((Object)n).isInstanceOf(Long.class);
        Assertions.assertThat((Long)((Long)n)).isGreaterThanOrEqualTo(notBefore);
    }

    @Test
    void shouldFetchAndUpdateBrokerStatisticsInGaugeRegistry() throws Exception {
        SimpleGaugeRegistry gaugeRegistry = new SimpleGaugeRegistry();
        ActiveMQMetricCollectorImpl testee = new ActiveMQMetricCollectorImpl(EMPTY_CONFIGURATION, (ConnectionFactory)connectionFactory, (MetricFactory)new RecordingMetricFactory(), (GaugeRegistry)gaugeRegistry);
        ActiveMQMetrics brokerStatistics = ActiveMQMetrics.forBroker((GaugeRegistry)gaugeRegistry);
        testee.fetchAndUpdate(brokerStatistics);
        Number n = gaugeRegistry.getGauge("ActiveMQ.Statistics.Broker.storeLimit");
        Assertions.assertThat((Object)n).isInstanceOf(Long.class);
        Assertions.assertThat((Long)((Long)n)).isGreaterThan(0L);
    }

    @Test
    void hasExecutionTimeMetrics() {
        RecordingMetricFactory metricFactory = new RecordingMetricFactory();
        NoopGaugeRegistry gaugeRegistry = new NoopGaugeRegistry();
        ActiveMQMetricCollectorImpl testee = new ActiveMQMetricCollectorImpl(EMPTY_CONFIGURATION, (ConnectionFactory)connectionFactory, (MetricFactory)metricFactory, (GaugeRegistry)gaugeRegistry);
        testee.start();
        testee.collectBrokerStatistics();
        testee.collectQueueStatistics(MailQueueName.of((String)"UNKNOWN"));
        Duration startDelay = EMPTY_CONFIGURATION.getMetricConfiguration().getStartDelay();
        Integer executionTimeCount = (Integer)Flux.interval((Duration)startDelay, (Duration)Duration.ofSeconds(1L)).take(3L, true).flatMap(n -> Mono.fromCallable(() -> metricFactory.executionTimesForPrefixName("ActiveMQ.").size())).blockLast();
        ((AbstractIntegerAssert)Assertions.assertThat((Integer)executionTimeCount).isNotNull()).isNotZero();
        testee.stop();
    }

    static {
        EMPTY_CONFIGURATION = ActiveMQConfiguration.getDefault();
    }

    private class SimpleGaugeRegistry
    implements GaugeRegistry {
        private final Map<String, Gauge<?>> gauges = new ConcurrentHashMap();

        private SimpleGaugeRegistry() {
        }

        public <T> GaugeRegistry register(String name, Gauge<T> gauge) {
            this.gauges.put(name, gauge);
            return this;
        }

        public <T> GaugeRegistry.SettableGauge<T> settableGauge(String name) {
            return t -> this.gauges.put(name, () -> t);
        }

        public Number getGauge(String name) {
            Gauge<?> g = this.gauges.get(name);
            if (g == null) {
                return null;
            }
            return (Number)g.get();
        }
    }
}

