/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.activemq.metric;

import java.time.Duration;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.queue.activemq.metric.ActiveMQMetricConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQMetricConfigurationTest {
    @Test
    void shouldUseDefaultForEmptyConfiguration() {
        Assertions.assertThat((Object)ActiveMQMetricConfiguration.from((Configuration)new BaseConfiguration())).isNotNull();
    }

    @Test
    void shouldNotFailForValidConfiguration() {
        Assertions.assertThat((Object)this.getSampleConfig(1, 10, 4, 3)).isNotNull();
    }

    @Test
    void shouldThrowWhenStartDelayIsLessThanMinimal() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(0, 10, 3, 3)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenIntervalIsLessThanMinimal() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 1, 3, 3)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenTimeoutIsLessThanMinimal() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 10, 1, 3)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenAqmpTimeoutIsLessThanMinimal() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 10, 3, 0)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenIntervalIsLessThanTimeout() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 5, 10, 2)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenTimeoutIsLessThanAqmpTimeout() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 10, 3, 5)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void shouldThrowWhenIntervalIsLessThanAqmpTimeout() {
        Assertions.assertThatThrownBy(() -> this.getSampleConfig(1, 5, 10, 9)).isInstanceOf(IllegalArgumentException.class);
    }

    private ActiveMQMetricConfiguration getSampleConfig(int startDelaySec, int intervalSec, int timeoutSec, int aqmpTimeoutSec) {
        return new ActiveMQMetricConfiguration(true, Duration.ofSeconds(startDelaySec), Duration.ofSeconds(intervalSec), Duration.ofSeconds(timeoutSec), Duration.ofSeconds(aqmpTimeoutSec));
    }
}

