/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.james.junit.ExecutorExtension;
import org.apache.james.queue.api.DelayedMailQueueContract;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.ManageableMailQueueContract;
import org.apache.mailet.Mail;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

@ExtendWith(value={ExecutorExtension.class})
public interface DelayedManageableMailQueueContract
extends DelayedMailQueueContract,
ManageableMailQueueContract {
    @Override
    public ManageableMailQueue getManageableMailQueue();

    default public void enQueue(Mail mail, long delay, TimeUnit unit) throws MailQueue.MailQueueException {
        this.getManageableMailQueue().enQueue(mail, delay, unit);
    }

    @Test
    default public void delayedMessagesShouldBeBrowesable() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build(), 30L, TimeUnit.SECONDS);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(mail -> mail.getMail().getName()).containsExactly((Object[])new String[]{"name1"});
    }

    @Test
    default public void delayedMessagesShouldBeCleared() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build(), 30L, TimeUnit.SECONDS);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
        this.getManageableMailQueue().clear();
        Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(0L);
    }

    @Test
    default public void delayedEmailsShouldBeDeleted() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("abc").build(), 5L, TimeUnit.SECONDS);
        this.enQueue((Mail)Mails.defaultMail().name("def").build(), 5L, TimeUnit.SECONDS);
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "abc");
        ArrayList names = new ArrayList();
        Flux.from((Publisher)this.getManageableMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).subscribe(item -> names.add(item.getMail().getName()));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((List)names).contains((Object[])new String[]{"def"}));
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"def"});
    }

    @Test
    default public void deletedDelayedMessagesShouldNotBeBrowseable() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build(), 30L, TimeUnit.SECONDS);
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name2").recipient(MailAddressFixture.RECIPIENT1).build());
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name3").recipient(MailAddressFixture.RECIPIENT2).build());
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, MailAddressFixture.RECIPIENT2.asString());
        this.awaitRemove();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(mail -> mail.getMail().getName()).containsExactly((Object[])new String[]{"name2"});
    }

    @Test
    default public void delayedEmailsShouldBeDeletedWhenMixedWithOtherEmails() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("abc").build(), 5L, TimeUnit.SECONDS);
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "abc");
        this.enQueue((Mail)Mails.defaultMail().name("def").build());
        this.enQueue((Mail)Mails.defaultMail().name("ghi").build(), 5L, TimeUnit.SECONDS);
        ArrayList names = new ArrayList();
        Flux.from((Publisher)this.getManageableMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).subscribe(item -> names.add(item.getMail().getName()));
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((List)names).contains((Object[])new String[]{"ghi"}));
        Assertions.assertThat(names).containsExactly((Object[])new String[]{"def", "ghi"});
    }

    @Test
    default public void flushShouldRemoveDelaysWhenImmediateMessageFirst() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build(), 30L, TimeUnit.HOURS);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(2L));
        this.getManageableMailQueue().flush();
        List items = (List)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).bufferTimeout(5, Duration.ofSeconds(5L)).blockFirst();
        Assertions.assertThat(items.stream().map(x -> x.getMail().getName())).containsExactly((Object[])new String[]{"name1", "name2"});
    }

    @Test
    default public void flushShouldRemoveDelays() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build(), 30L, TimeUnit.HOURS);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
        this.getManageableMailQueue().flush();
        Assertions.assertThat((String)((MailQueue.MailQueueItem)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).blockFirst(Duration.ofSeconds(5L))).getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void flushShouldPreserveBrowseOrder() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build(), 30L, TimeUnit.SECONDS);
        this.enQueue((Mail)Mails.defaultMail().name("name3").build(), 2L, TimeUnit.SECONDS);
        this.getManageableMailQueue().flush();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name1", "name2", "name3"});
    }
}

