/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import com.github.fge.lambdas.Throwing;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.Mails;
import org.apache.james.util.MimeMessageUtil;
import org.apache.james.util.concurrency.ConcurrentTestRunner;
import org.apache.mailet.Attribute;
import org.apache.mailet.DsnParameters;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface MailQueueContract {
    public MailQueue getMailQueue();

    default public void enQueue(Mail mail) throws MailQueue.MailQueueException {
        this.getMailQueue().enQueue(mail);
    }

    @Test
    default public void queueShouldPreserveDsnParameters() throws Exception {
        DsnParameters dsnParameters = (DsnParameters)DsnParameters.builder().envId(DsnParameters.EnvId.of((String)"434554-55445-33443")).ret(DsnParameters.Ret.FULL).addRcptParameter(new MailAddress("bob@apache.org"), DsnParameters.RecipientDsnParameters.of((MailAddress)new MailAddress("andy@apache.org"))).addRcptParameter(new MailAddress("cedric@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.SUCCESS))).addRcptParameter(new MailAddress("domi@apache.org"), DsnParameters.RecipientDsnParameters.of(EnumSet.of(DsnParameters.Notify.FAILURE), (MailAddress)new MailAddress("eric@apache.org"))).build().get();
        FakeMail mail = Mails.defaultMail().name("mail").build();
        mail.setDsnParameters(dsnParameters);
        this.enQueue((Mail)mail);
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Optional)mailQueueItem.getMail().dsnParameters()).contains((Object)dsnParameters);
    }

    @Test
    default public void queueShouldSupportBigMail() throws Exception {
        String name = "name1";
        String messageText = Strings.repeat((String)"0123456789\r\n", (int)0x100000);
        FakeMail mail = Mails.defaultMail().name(name).mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setText(messageText)).build();
        this.enQueue((Mail)mail);
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getName()).isEqualTo(name);
    }

    @Test
    default public void queueShouldPreserveMailRecipients() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("mail").recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Collection)mailQueueItem.getMail().getRecipients()).containsOnly((Object[])new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2});
    }

    @Test
    default public void queueShouldHandleSender() throws Exception {
        this.enQueue((Mail)FakeMail.builder().name("name").mimeMessage(Mails.createMimeMessage()).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).sender(MailAddress.nullSender()).lastUpdated(new Date()).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Object)mailQueueItem.getMail().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    default public void enQueueShouldAcceptMailWithDuplicatedNames() throws Exception {
        String name = "name";
        FakeMail mail = FakeMail.builder().name(name).mimeMessage(Mails.createMimeMessage()).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).sender(MailAddress.nullSender()).lastUpdated(new Date()).build();
        this.enQueue((Mail)mail);
        this.enQueue((Mail)mail);
        Stream dequeuedItemNames = Flux.from((Publisher)this.getMailQueue().deQueue()).take(2L).map(MailQueue.MailQueueItem::getMail).map(Mail::getName).toStream();
        ((ListAssert)Assertions.assertThat((Stream)dequeuedItemNames).hasSize(2)).containsOnly((Object[])new String[]{name});
    }

    @Test
    default public void queueShouldHandleNoSender() throws Exception {
        this.enQueue((Mail)FakeMail.builder().name("name").mimeMessage(Mails.createMimeMessage()).recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).lastUpdated(new Date()).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Object)mailQueueItem.getMail().getMaybeSender()).isEqualTo((Object)MaybeSender.nullSender());
    }

    @Test
    default public void queueShouldPreserveMailSender() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("mail").sender(MailAddressFixture.SENDER).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Object)mailQueueItem.getMail().getMaybeSender()).isEqualTo((Object)MaybeSender.of((MailAddress)MailAddressFixture.SENDER));
    }

    @Test
    default public void queueShouldPreserveMimeMessage() throws Exception {
        MimeMessage originalMimeMessage = Mails.createMimeMessage();
        this.enQueue((Mail)Mails.defaultMail().name("mail").mimeMessage(originalMimeMessage).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)MimeMessageUtil.asString((MimeMessage)mailQueueItem.getMail().getMessage())).isEqualTo(MimeMessageUtil.asString((MimeMessage)originalMimeMessage));
    }

    @Test
    default public void queueShouldPreserveMailAttribute() throws Exception {
        Attribute attribute = Attribute.convertToAttribute((String)"any", (Object)"value");
        this.enQueue((Mail)Mails.defaultMail().name("mail").attribute(attribute).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Optional)mailQueueItem.getMail().getAttribute(attribute.getName())).contains((Object)attribute);
    }

    @Test
    default public void queueShouldPreserveErrorMessage() throws Exception {
        String errorMessage = "ErrorMessage";
        this.enQueue((Mail)Mails.defaultMail().name("mail").errorMessage(errorMessage).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getErrorMessage()).isEqualTo(errorMessage);
    }

    @Test
    default public void queueShouldPreserveState() throws Exception {
        String state = "state";
        this.enQueue((Mail)Mails.defaultMail().name("mail").state(state).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getState()).isEqualTo(state);
    }

    @Test
    default public void queueShouldPreserveRemoteAddress() throws Exception {
        String remoteAddress = "remote";
        this.enQueue((Mail)Mails.defaultMail().name("mail").remoteAddr(remoteAddress).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getRemoteAddr()).isEqualTo(remoteAddress);
    }

    @Test
    default public void queueShouldPreserveRemoteHost() throws Exception {
        String remoteHost = "remote";
        this.enQueue((Mail)Mails.defaultMail().name("mail").remoteHost(remoteHost).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getRemoteHost()).isEqualTo(remoteHost);
    }

    @Test
    default public void queueShouldPreserveLastUpdated() throws Exception {
        Date lastUpdated = new Date();
        this.enQueue((Mail)Mails.defaultMail().name("mail").lastUpdated(lastUpdated).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Date)mailQueueItem.getMail().getLastUpdated()).isEqualTo((Object)lastUpdated);
    }

    @Test
    default public void queueShouldPreserveName() throws Exception {
        String expectedName = "name";
        this.enQueue((Mail)Mails.defaultMail().name(expectedName).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getName()).isEqualTo(expectedName);
    }

    @Test
    default public void queueShouldPreservePerRecipientHeaders() throws Exception {
        PerRecipientHeaders.Header header = PerRecipientHeaders.Header.builder().name("any").value("any").build();
        this.enQueue((Mail)Mails.defaultMail().name("mail").addHeaderForRecipient(header, MailAddressFixture.RECIPIENT1).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Collection)mailQueueItem.getMail().getPerRecipientSpecificHeaders().getHeadersForRecipient(MailAddressFixture.RECIPIENT1)).containsOnly((Object[])new PerRecipientHeaders.Header[]{header});
    }

    @Test
    default public void queueShouldPreserveMultiplePerRecipientHeaders() throws Exception {
        PerRecipientHeaders.Header header = PerRecipientHeaders.Header.builder().name("any").value("any").build();
        PerRecipientHeaders.Header header2 = PerRecipientHeaders.Header.builder().name("any2").value("any").build();
        this.enQueue((Mail)Mails.defaultMail().name("mail").addHeaderForRecipient(header, MailAddressFixture.RECIPIENT1).addHeaderForRecipient(header2, MailAddressFixture.RECIPIENT1).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Collection)mailQueueItem.getMail().getPerRecipientSpecificHeaders().getHeadersForRecipient(MailAddressFixture.RECIPIENT1)).containsOnly((Object[])new PerRecipientHeaders.Header[]{header, header2});
    }

    @Test
    default public void queueShouldPreserveNonStringMailAttribute() throws Exception {
        Attribute attribute = Attribute.convertToAttribute((String)"any", (Object)new SerializableAttribute("value"));
        this.enQueue((Mail)Mails.defaultMail().name("mail").attribute(attribute).build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Optional)mailQueueItem.getMail().getAttribute(attribute.getName())).hasValueSatisfying(item -> {
            Assertions.assertThat((Object)item).isEqualTo((Object)attribute);
            Assertions.assertThat((Object)item.getValue().value()).isInstanceOf(SerializableAttribute.class);
        });
    }

    @Test
    default public void dequeueShouldBeFifo() throws Exception {
        String firstExpectedName = "name1";
        this.enQueue((Mail)Mails.defaultMail().name(firstExpectedName).build());
        String secondExpectedName = "name2";
        this.enQueue((Mail)Mails.defaultMail().name(secondExpectedName).build());
        Iterator items = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem1.done(true);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem2.done(true);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo(firstExpectedName);
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo(secondExpectedName);
    }

    @Test
    default public void dequeueCanBeChainedBeforeAck() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Iterator items = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)items.next();
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem1.done(true);
        mailQueueItem2.done(true);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void dequeueCouldBeInterleavingWithOutOfOrderAck() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Iterator items = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)items.next();
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem2.done(true);
        mailQueueItem1.done(true);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void dequeueShouldAllowRetrieveFailItems() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        Iterator items = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem1.done(false);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem2.done(true);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void dequeueShouldAllowRetrieveFailItemsNackOutOfOrder() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        Iterator items = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)items.next();
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)items.next();
        mailQueueItem2.done(true);
        mailQueueItem1.done(false);
        MailQueue.MailQueueItem mailQueueItem1bis = (MailQueue.MailQueueItem)items.next();
        MailQueue.MailQueueItem mailQueueItem3 = (MailQueue.MailQueueItem)items.next();
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name2");
        Assertions.assertThat(List.of(mailQueueItem1bis, mailQueueItem3).stream().map(item -> item.getMail().getName())).containsOnly((Object[])new String[]{"name1", "name3"});
    }

    @Test
    default public void dequeueShouldNotReturnInProcessingEmails() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        LinkedBlockingQueue queue = new LinkedBlockingQueue(1);
        Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).subscribe((Consumer)Throwing.consumer(queue::put));
        queue.take();
        Assertions.assertThat((Object)((MailQueue.MailQueueItem)queue.poll(2L, TimeUnit.SECONDS))).isNull();
    }

    @Test
    default public void deQueueShouldBlockWhenNoMail() {
        Mono item = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(Schedulers.elastic()).next();
        Assertions.assertThatThrownBy(() -> item.block(Duration.ofSeconds(2L))).isInstanceOf(RuntimeException.class);
    }

    @Test
    default public void deQueueShouldWaitForAMailToBeEnqueued() throws Exception {
        MailQueue testee = this.getMailQueue();
        FakeMail mail = Mails.defaultMail().name("name").build();
        Mono item = Flux.from((Publisher)testee.deQueue()).next();
        testee.enQueue((Mail)mail);
        Assertions.assertThat((String)((MailQueue.MailQueueItem)item.block(Duration.ofMinutes(1L))).getMail().getName()).isEqualTo("name");
    }

    @Test
    default public void concurrentEnqueueDequeueShouldNotFail() throws Exception {
        MailQueue testee = this.getMailQueue();
        ConcurrentLinkedDeque dequeuedMails = new ConcurrentLinkedDeque();
        int threadCount = 10;
        int operationCount = 10;
        int totalDequeuedMessages = 50;
        LinkedBlockingQueue itemQueue = new LinkedBlockingQueue(1);
        Flux.from((Publisher)testee.deQueue()).subscribeOn(Schedulers.elastic()).flatMap(e -> {
            try {
                itemQueue.put(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return Mono.empty();
        }).subscribe();
        ConcurrentTestRunner.builder().operation((threadNumber, step) -> {
            if (step % 2 == 0) {
                testee.enQueue((Mail)Mails.defaultMail().name("name" + threadNumber + "-" + step).build());
            } else {
                MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)itemQueue.take();
                dequeuedMails.add(mailQueueItem.getMail());
                mailQueueItem.done(true);
            }
        }).threadCount(threadCount).operationCount(operationCount).runSuccessfullyWithin(Duration.ofMinutes(5L));
        Assertions.assertThat(dequeuedMails.stream().map(Mail::getName).distinct()).hasSize(totalDequeuedMessages);
    }

    @Test
    default public void concurrentEnqueueDequeueWithAckNackShouldNotFail() throws Exception {
        MailQueue testee = this.getMailQueue();
        ConcurrentLinkedDeque dequeuedMails = new ConcurrentLinkedDeque();
        int threadCount = 10;
        int operationCount = 15;
        int totalDequeuedMessages = 50;
        LinkedBlockingDeque deque = new LinkedBlockingDeque();
        Flux.from((Publisher)testee.deQueue()).subscribeOn(Schedulers.elastic()).doOnNext(deque::addFirst).subscribe();
        ConcurrentTestRunner.builder().operation((threadNumber, step) -> {
            MailQueue.MailQueueItem mailQueueItem;
            if (step % 3 == 0) {
                testee.enQueue((Mail)Mails.defaultMail().name("name" + threadNumber + "-" + step).build());
            }
            if (step % 3 == 1) {
                mailQueueItem = (MailQueue.MailQueueItem)deque.takeLast();
                mailQueueItem.done(false);
            }
            if (step % 3 == 2) {
                mailQueueItem = (MailQueue.MailQueueItem)deque.takeLast();
                dequeuedMails.add(mailQueueItem.getMail());
                mailQueueItem.done(true);
            }
        }).threadCount(threadCount).operationCount(operationCount).runSuccessfullyWithin(Duration.ofMinutes(1L));
        Assertions.assertThat(dequeuedMails.stream().map(Mail::getName).distinct()).hasSize(totalDequeuedMessages);
    }

    @Test
    default public void dequeueShouldBeConcurrent() {
        MailQueue testee = this.getMailQueue();
        int nbMails = 1000;
        IntStream.range(0, nbMails).forEach((IntConsumer)Throwing.intConsumer(i -> testee.enQueue((Mail)Mails.defaultMail().name("name" + i).build())));
        ConcurrentLinkedDeque dequeuedMails = new ConcurrentLinkedDeque();
        Flux.from((Publisher)testee.deQueue()).flatMap(item -> Mono.defer(() -> {
            dequeuedMails.add(item.getMail());
            try {
                Thread.sleep(100L);
                item.done(true);
                return Mono.empty();
            }
            catch (InterruptedException | MailQueue.MailQueueException e) {
                return Mono.error((Throwable)e);
            }
        }).subscribeOn(Schedulers.elastic()), 1000).subscribeOn(Schedulers.newSingle((String)"foo")).subscribe();
        Awaitility.await().atMost(Durations.ONE_MINUTE).until(() -> dequeuedMails.size() >= nbMails);
    }

    public static class SerializableAttribute
    implements Serializable {
        private final String value;

        SerializableAttribute(String value) {
            this.value = value;
        }

        public final boolean equals(Object o) {
            if (o instanceof SerializableAttribute) {
                SerializableAttribute that = (SerializableAttribute)o;
                return Objects.equals(this.value, that.value);
            }
            return false;
        }

        public final int hashCode() {
            return Objects.hash(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

