/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.util.Collection;
import java.util.Optional;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface MailQueueFactoryContract<T extends MailQueue> {
    public static final MailQueueName NAME_1 = MailQueueName.of((String)"name1");
    public static final MailQueueName NAME_2 = MailQueueName.of((String)"name2");

    public MailQueueFactory<T> getMailQueueFactory();

    @Test
    default public void getUsedMailQueuesShouldReturnWhenNoMailQueue() {
        Assertions.assertThat((Collection)this.getMailQueueFactory().listCreatedMailQueues()).isEmpty();
    }

    @Test
    default public void getUsedMailQueuesShouldReturnPreviouslyCreatedMailQueues() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        mailQueueFactory.createQueue(NAME_1);
        mailQueueFactory.createQueue(NAME_2);
        Assertions.assertThat((Collection)mailQueueFactory.listCreatedMailQueues()).containsOnly((Object[])new MailQueueName[]{NAME_1, NAME_2});
    }

    @Test
    default public void getUsedMailQueuesShouldNotReturnDuplicate() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        mailQueueFactory.createQueue(NAME_1);
        mailQueueFactory.createQueue(NAME_1);
        Assertions.assertThat((Collection)mailQueueFactory.listCreatedMailQueues()).containsOnly((Object[])new MailQueueName[]{NAME_1});
    }

    @Test
    default public void getMailQueueShouldReturnEmptyIfNotCreated() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        Assertions.assertThat((Optional)mailQueueFactory.getQueue(NAME_1)).isEmpty();
    }

    @Test
    default public void getMailQueueShouldReturnMailQueueIfCreated() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        mailQueueFactory.createQueue(NAME_1);
        Assertions.assertThat(mailQueueFactory.getQueue(NAME_1).map(MailQueue::getName)).contains((Object)NAME_1);
    }

    @Test
    default public void getMailQueueShouldReturnEmptyIfQueueDoesNotExist() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        mailQueueFactory.createQueue(NAME_1);
        Assertions.assertThat((Optional)mailQueueFactory.getQueue(NAME_2)).isEmpty();
    }

    @Test
    default public void getMailQueueShouldNotReturnTheSameQueueForTwoDifferentNames() {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        mailQueueFactory.createQueue(NAME_1);
        mailQueueFactory.createQueue(NAME_2);
        Assertions.assertThat((Optional)mailQueueFactory.getQueue(NAME_1)).isNotEqualTo((Object)mailQueueFactory.getQueue(NAME_2));
    }
}

