/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import com.github.fge.lambdas.Throwing;
import java.util.Collection;
import java.util.Map;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import javax.mail.MessagingException;
import org.apache.james.metrics.api.Gauge;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.queue.api.MailQueueContract;
import org.apache.james.queue.api.MailQueueMetricExtension;
import org.apache.james.queue.api.Mails;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ExtendWith(value={MailQueueMetricExtension.class})
public interface MailQueueMetricContract
extends MailQueueContract {
    default public FakeMail fakeMail(int i) throws MessagingException {
        return Mails.defaultMail().name("name" + i).build();
    }

    default public void enQueueMail(Integer times) {
        IntStream.rangeClosed(1, times).forEach((IntConsumer)Throwing.intConsumer(time -> this.enQueue((Mail)this.fakeMail(time))));
    }

    default public void deQueueMail(Integer times) {
        Flux.from((Publisher)this.getMailQueue().deQueue()).take((long)times.intValue()).flatMap(x -> Mono.fromCallable(() -> {
            x.done(true);
            return x;
        })).blockLast();
    }

    @Test
    default public void constructorShouldRegisterGetQueueSizeGauge(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) {
        this.enQueueMail(3);
        ArgumentCaptor gaugeCaptor = ArgumentCaptor.forClass(Gauge.class);
        ((GaugeRegistry)Mockito.verify((Object)testSystem.getSpyGaugeRegistry(), (VerificationMode)Mockito.times((int)1))).register(ArgumentMatchers.startsWith((String)"mailQueueSize:"), (Gauge)gaugeCaptor.capture());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{testSystem.getSpyGaugeRegistry()});
        Gauge registeredGauge = (Gauge)gaugeCaptor.getValue();
        Assertions.assertThat((Object)registeredGauge.get()).isEqualTo((Object)3L);
    }

    @Test
    default public void enqueueShouldIncreaseEnQueueMetric(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) {
        this.enQueueMail(2);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("enqueuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)2);
        }}));
    }

    @Test
    default public void enqueueShouldNotTouchDequeueMetric(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) throws InterruptedException {
        this.enQueueMail(2);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("enqueuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)2);
        }}));
        ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("dequeuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)0);
        }});
    }

    @Test
    default public void dequeueShouldIncreaseDequeueMetric(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) {
        this.enQueueMail(2);
        this.deQueueMail(2);
        ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("dequeuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)2);
        }});
    }

    @Test
    default public void dequeueShouldNotTouchEnqueueMetric(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) {
        this.enQueueMail(2);
        this.deQueueMail(2);
        Awaitility.await().atMost(Durations.FIVE_SECONDS).untilAsserted(() -> ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("dequeuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)2);
        }}));
        ((MapAssert)Assertions.assertThat((Map)testSystem.getMetricFactory().countForPrefixName("enqueuedMail:")).hasSize(1)).satisfies(new ThrowingConsumer[]{values -> {
            Assertions.assertThat(values.values()).hasSize(1);
            ((ObjectAssert)Assertions.assertThat(values.values()).element(0)).isEqualTo((Object)2);
        }});
    }

    @Test
    default public void enqueueShouldPublishEnqueueTimeMetric(MailQueueMetricExtension.MailQueueMetricTestSystem testSystem) {
        this.enQueueMail(2);
        Assertions.assertThat((Object)testSystem.getMetricFactory().executionTimesForPrefixName("enqueueTime:")).satisfies(new ThrowingConsumer[]{executionMap -> {
            Assertions.assertThat((Collection)executionMap.keySet()).hasSize(1);
            Assertions.assertThat((Collection)executionMap.values()).hasSize(2);
        }});
    }
}

