/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.time.Duration;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.MimeMessage;
import org.apache.james.core.MailAddress;
import org.apache.james.core.builder.MimeMessageBuilder;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueContract;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.mailet.Attribute;
import org.apache.mailet.Mail;
import org.apache.mailet.base.MailAddressFixture;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface ManageableMailQueueContract
extends MailQueueContract {
    default public void awaitRemove() {
    }

    public ManageableMailQueue getManageableMailQueue();

    @Test
    default public void getSizeShouldReturnZeroWhenNoMessage() throws Exception {
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(0L));
    }

    @Test
    default public void getSizeShouldReturnMessageCount() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
    }

    @Test
    default public void getSizeShouldReturnMessageCountWhenSeveralMails() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("1").build());
        this.enQueue((Mail)Mails.defaultMail().name("2").build());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(2L));
    }

    @Test
    default public void dequeueShouldDecreaseQueueSize() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        Flux.from((Publisher)this.getManageableMailQueue().deQueue()).doOnNext((Consumer)Throwing.consumer(item -> item.done(true))).blockFirst();
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(0L));
    }

    @Test
    default public void noAckShouldNotDecreaseSize() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        Flux.from((Publisher)this.getManageableMailQueue().deQueue()).doOnNext((Consumer)Throwing.consumer(item -> item.done(false))).blockFirst();
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
    }

    @Test
    default public void processedMailsShouldNotDecreaseSize() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        Flux.from((Publisher)this.getManageableMailQueue().deQueue());
        Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L);
    }

    @Test
    default public void browseShouldReturnEmptyByDefault() throws Exception {
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        Assertions.assertThat((Iterator)items).toIterable().isEmpty();
    }

    @Test
    default public void browseShouldReturnSingleElement() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        Assertions.assertThat((Iterator)items).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name"});
    }

    @Test
    default public void browseShouldReturnElementsInOrder() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        Assertions.assertThat((Iterator)items).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name1", "name2", "name3"});
    }

    @Test
    default public void dequeueShouldNotFailWhenBrowsing() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        this.getManageableMailQueue().browse();
        Assertions.assertThatCode(() -> Flux.from((Publisher)this.getManageableMailQueue().deQueue())).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentDequeue() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        Flux.from((Publisher)this.getManageableMailQueue().deQueue());
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void dequeueShouldNotFailWhenBrowsingIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Assertions.assertThatCode(() -> Flux.from((Publisher)this.getManageableMailQueue().deQueue())).doesNotThrowAnyException();
    }

    @Test
    default public void dequeueShouldReturnDecoratedMailItem() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        Assertions.assertThat((Object)((MailQueue.MailQueueItem)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).blockFirst(Duration.ofMinutes(1L)))).isInstanceOf(MailQueueItemDecoratorFactory.MailQueueItemDecorator.class);
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentDequeueWhenIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Flux.from((Publisher)this.getManageableMailQueue().deQueue());
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void enqueueShouldNotFailWhenBrowsing() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        this.getManageableMailQueue().browse();
        Assertions.assertThatCode(() -> this.enQueue((Mail)Mails.defaultMail().name("name4").build())).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentEnqueue() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        this.enQueue((Mail)Mails.defaultMail().name("name4").build());
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void enqueueShouldNotFailWhenBrowsingIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Assertions.assertThatCode(() -> this.enQueue((Mail)Mails.defaultMail().name("name4").build())).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentEnqueueWhenIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void clearShouldNotFailWhenBrowsingIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Assertions.assertThatCode(() -> this.getManageableMailQueue().clear()).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentClearWhenIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        this.getManageableMailQueue().clear();
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void flushShouldNotFailWhenBrowsingIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Assertions.assertThatCode(() -> this.getManageableMailQueue().flush()).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentFlushWhenIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        this.getManageableMailQueue().flush();
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void removeShouldNotFailWhenBrowsingIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        Assertions.assertThatCode(() -> this.getManageableMailQueue().flush()).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldNotFailWhenConcurrentRemoveWhenIterating() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "name2");
        this.awaitRemove();
        Assertions.assertThatCode(() -> Iterators.consumingIterator((Iterator)items)).doesNotThrowAnyException();
    }

    @Test
    default public void browseShouldReturnMailsWithMimeMessage() throws Exception {
        ManageableMailQueue mailQueue = this.getManageableMailQueue();
        mailQueue.enQueue((Mail)Mails.defaultMail().name("mail with blob").mimeMessage(MimeMessageBuilder.mimeMessageBuilder().setSubject("mail subject").setText("mail body").build()).build());
        MimeMessage mimeMessage = ((ManageableMailQueue.MailQueueItemView)mailQueue.browse().next()).getMail().getMessage();
        String subject = mimeMessage.getSubject();
        Object content = mimeMessage.getContent();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(subject).isEqualTo("mail subject");
            softly.assertThat(content).isEqualTo((Object)"mail body");
        });
    }

    @Test
    default public void browseShouldReturnMailsWithAttributes() throws Exception {
        Attribute attribute1 = Attribute.convertToAttribute((String)"Attribute Name 1", (Object)"Attribute Value 1");
        Attribute attribute2 = Attribute.convertToAttribute((String)"Attribute Name 2", (Object)"Attribute Value 2");
        ManageableMailQueue mailQueue = this.getManageableMailQueue();
        mailQueue.enQueue((Mail)Mails.defaultMail().name("mail with blob").attributes((Collection)ImmutableList.of((Object)attribute1, (Object)attribute2)).build());
        Mail mail = ((ManageableMailQueue.MailQueueItemView)mailQueue.browse().next()).getMail();
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat(mail.getAttribute(attribute1.getName())).contains((Object)attribute1);
            softly.assertThat(mail.getAttribute(attribute2.getName())).contains((Object)attribute2);
        });
    }

    @Test
    default public void browsingShouldNotAffectDequeue() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.enQueue((Mail)Mails.defaultMail().name("name3").build());
        ManageableMailQueue.MailQueueIterator items = this.getManageableMailQueue().browse();
        items.next();
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void removeByNameShouldRemoveSpecificEmail() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "name2");
        this.awaitRemove();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name1"});
    }

    @Test
    default public void removeBySenderShouldRemoveSpecificEmail() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").sender(MailAddressFixture.OTHER_AT_LOCAL).build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").sender(MailAddressFixture.SENDER).build());
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Sender, MailAddressFixture.OTHER_AT_LOCAL.asString());
        this.awaitRemove();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name2"});
    }

    @Test
    default public void removeByRecipientShouldRemoveSpecificEmail() throws Exception {
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name1").recipient(MailAddressFixture.RECIPIENT1).build());
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name2").recipient(MailAddressFixture.RECIPIENT2).build());
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, MailAddressFixture.RECIPIENT2.asString());
        this.awaitRemove();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name1"});
    }

    public static Stream<Arguments> removeByRecipientShouldRemoveSpecificEmailWhenMultipleRecipients() throws AddressException {
        return Stream.of(Arguments.of((Object[])new Object[]{List.of(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2), MailAddressFixture.RECIPIENT2}), Arguments.of((Object[])new Object[]{List.of(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2), MailAddressFixture.RECIPIENT1}), Arguments.of((Object[])new Object[]{List.of(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2, MailAddressFixture.RECIPIENT3), MailAddressFixture.RECIPIENT2}), Arguments.of((Object[])new Object[]{List.of(MailAddressFixture.RECIPIENT1, new MailAddress(MailAddressFixture.RECIPIENT1.asString() + ".local"), MailAddressFixture.RECIPIENT2), MailAddressFixture.RECIPIENT1}), Arguments.of((Object[])new Object[]{List.of(MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2, new MailAddress(MailAddressFixture.RECIPIENT1.asString() + ".local")), MailAddressFixture.RECIPIENT1}), Arguments.of((Object[])new Object[]{List.of(new MailAddress(MailAddressFixture.RECIPIENT1.asString() + ".local"), MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2), MailAddressFixture.RECIPIENT1}), Arguments.of((Object[])new Object[]{List.of(new MailAddress(MailAddressFixture.RECIPIENT1.asString() + ".local"), MailAddressFixture.RECIPIENT2, MailAddressFixture.RECIPIENT1), MailAddressFixture.RECIPIENT1}));
    }

    @ParameterizedTest
    @MethodSource
    default public void removeByRecipientShouldRemoveSpecificEmailWhenMultipleRecipients(List<MailAddress> recipients, MailAddress toRemove) throws Exception {
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name1").recipients(recipients).build());
        this.enQueue((Mail)Mails.defaultMailNoRecipient().name("name2").recipients(recipients.stream().filter(recipient -> !recipient.equals((Object)toRemove)).collect(Collectors.toList())).build());
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, toRemove.asString());
        this.awaitRemove();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name2"});
    }

    @Test
    default public void removeByNameShouldNotFailWhenQueueIsEmpty() throws Exception {
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "NAME2");
    }

    @Test
    default public void removeBySenderShouldNotFailWhenQueueIsEmpty() throws Exception {
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Sender, MailAddressFixture.OTHER_AT_LOCAL.asString());
    }

    @Test
    default public void removeByRecipientShouldNotFailWhenQueueIsEmpty() throws Exception {
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, MailAddressFixture.OTHER_AT_LOCAL.asString());
    }

    @Test
    default public void clearShouldNotFailWhenQueueIsEmpty() throws Exception {
        this.getManageableMailQueue().clear();
    }

    @Test
    default public void flushShouldNotFailWhenQueueIsEmpty() throws Exception {
        this.getManageableMailQueue().flush();
    }

    @Test
    default public void clearShouldRemoveAllElements() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        this.getManageableMailQueue().clear();
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().isEmpty();
    }

    @Test
    default public void deletedElementsShouldNotBeDequeued() throws Exception {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(2L));
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Name, "name1");
        this.awaitRemove();
        Assertions.assertThat((String)((MailQueue.MailQueueItem)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).blockFirst()).getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void removeShouldNotDeleteFutureEmails() throws MessagingException {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, MailAddressFixture.RECIPIENT1.asString());
        this.awaitRemove();
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Assertions.assertThat((String)((MailQueue.MailQueueItem)Flux.from((Publisher)this.getManageableMailQueue().deQueue()).blockFirst()).getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void removeShouldNotDeleteFutureEmailsFromBrowse() throws MessagingException {
        this.enQueue((Mail)Mails.defaultMail().name("name1").build());
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)this.getManageableMailQueue().getSize()).isEqualTo(1L));
        this.getManageableMailQueue().remove(ManageableMailQueue.Type.Recipient, MailAddressFixture.RECIPIENT1.asString());
        this.awaitRemove();
        this.enQueue((Mail)Mails.defaultMail().name("name2").build());
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(mail -> mail.getMail().getName()).containsExactly((Object[])new String[]{"name2"});
    }
}

