/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.util.Iterator;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.api.ManageableMailQueueContract;
import org.apache.james.queue.api.PriorityMailQueueContract;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public interface PriorityManageableMailQueueContract
extends ManageableMailQueueContract,
PriorityMailQueueContract {
    @Override
    public ManageableMailQueue getManageableMailQueue();

    @Test
    default public void browseShouldBeOrderedByPriority() throws Exception {
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name3").attribute(this.mailPriority(3)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name9").attribute(this.mailPriority(9)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(this.mailPriority(1)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name8").attribute(this.mailPriority(8)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name6").attribute(this.mailPriority(6)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name0").attribute(this.mailPriority(0)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name7").attribute(this.mailPriority(7)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name4").attribute(this.mailPriority(4)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(this.mailPriority(2)).build());
        this.getManageableMailQueue().enQueue((Mail)Mails.defaultMail().name("name5").attribute(this.mailPriority(5)).build());
        Assertions.assertThat((Iterator)this.getManageableMailQueue().browse()).toIterable().extracting(ManageableMailQueue.MailQueueItemView::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name9", "name8", "name7", "name6", "name5", "name4", "name3", "name2", "name1", "name0"});
    }

    default public Attribute mailPriority(Integer priority) {
        return new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.of((Integer)priority));
    }
}

