/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import com.google.common.base.Stopwatch;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueContract;
import org.apache.james.queue.api.Mails;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface DelayedMailQueueContract {
    public MailQueue getMailQueue();

    @Test
    default public void enqueueShouldDelayMailsWhenSpecified() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name").build(), 5L, TimeUnit.SECONDS);
        Mono next = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).next();
        Assertions.assertThatThrownBy(() -> next.block(Duration.ofSeconds(1L))).isInstanceOf(RuntimeException.class);
    }

    @Test
    default public void enqueueWithNegativeDelayShouldNotDelayDelivery() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name").build(), -30L, TimeUnit.SECONDS);
        Mono next = Flux.from((Publisher)this.getMailQueue().deQueue()).next();
        Assertions.assertThatCode(() -> next.block(Duration.ofSeconds(1L))).doesNotThrowAnyException();
    }

    @Test
    default public void enqueueWithReasonablyLongDelayShouldDelayMail() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name").build(), 3650L, TimeUnit.DAYS);
        Mono next = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).next();
        Assertions.assertThatThrownBy(() -> next.block(Duration.ofSeconds(1L))).isInstanceOf(RuntimeException.class);
    }

    @Test
    default public void enqueueWithVeryLongDelayShouldDelayMail() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name").build(), ChronoUnit.YEARS.getDuration().multipliedBy(291L));
        Mono next = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).next();
        Assertions.assertThatThrownBy(() -> next.block(Duration.ofSeconds(1L))).isInstanceOf(RuntimeException.class);
    }

    @Test
    default public void delayedMailCanBeRetrievedFromTheQueue() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").build(), 1L, TimeUnit.SECONDS);
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void delayShouldAtLeastBeTheOneSpecified() throws Exception {
        long delay = 3L;
        TimeUnit unit = TimeUnit.SECONDS;
        Stopwatch started = Stopwatch.createStarted();
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name").build(), delay, unit);
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((Object)mailQueueItem).isNotNull();
        int epsilon = 1;
        Assertions.assertThat((Duration)started.elapsed()).isGreaterThan((Comparable)Duration.ofSeconds(delay - (long)epsilon));
    }
}

