/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.james.queue.api.DelayedMailQueueContract;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueContract;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.PriorityMailQueueContract;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public interface DelayedPriorityMailQueueContract
extends DelayedMailQueueContract,
PriorityMailQueueContract {
    @Override
    public MailQueue getMailQueue();

    @Test
    default public void delayedHighPriorityMailShouldBeDeQueuedBeforeLowPriorityNonDelayedMailAfterDelayExpiracy() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(MailPrioritySupport.LOW_PRIORITY_ATTRIBUTE).build());
        int delay = 1;
        TimeUnit unit = TimeUnit.SECONDS;
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(MailPrioritySupport.HIGH_PRIORITY_ATTRIBUTE).build(), (long)delay, unit);
        Thread.sleep(unit.toMillis(2 * delay));
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem item1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        item1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem item2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        item2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)item1.getMail().getName()).isEqualTo("name2");
        Assertions.assertThat((String)item2.getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void delayedHighPriorityMailShouldBeDeQueuedAfterNonDelayedMail() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(MailPrioritySupport.LOW_PRIORITY_ATTRIBUTE).build());
        int delay = 1;
        TimeUnit unit = TimeUnit.SECONDS;
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(MailPrioritySupport.HIGH_PRIORITY_ATTRIBUTE).build(), (long)delay, unit);
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem item1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        item1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem item2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        item2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)item1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)item2.getMail().getName()).isEqualTo("name2");
    }
}

