/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import javax.mail.MessagingException;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.queue.api.Mails;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;

public interface ManageableMailQueueFactoryContract<T extends ManageableMailQueue> {
    public static final MailQueueName NAME_1 = MailQueueName.of((String)"name1");

    public MailQueueFactory<T> getMailQueueFactory();

    @Test
    default public void createMailQueueShouldNotConflictIfAlreadyExists() throws MessagingException {
        MailQueueFactory<T> mailQueueFactory = this.getMailQueueFactory();
        MailQueue firstCreation = mailQueueFactory.createQueue(NAME_1);
        firstCreation.enQueue((Mail)Mails.defaultMail().name("name").build());
        ManageableMailQueue secondCreation = (ManageableMailQueue)mailQueueFactory.createQueue(NAME_1);
        Awaitility.await().untilAsserted(() -> Assertions.assertThat((long)secondCreation.getSize()).isEqualTo(1L));
    }
}

