/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.api;

import java.util.Iterator;
import org.apache.james.queue.api.MailPrioritySupport;
import org.apache.james.queue.api.MailQueue;
import org.apache.james.queue.api.MailQueueContract;
import org.apache.james.queue.api.Mails;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface PriorityMailQueueContract {
    public MailQueue getMailQueue();

    @Test
    default public void priorityShouldReorderMailsWhenDequeing() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name3").attribute(this.mailPriority(3)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name9").attribute(this.mailPriority(9)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(this.mailPriority(1)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name8").attribute(this.mailPriority(8)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name6").attribute(this.mailPriority(6)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name0").attribute(this.mailPriority(0)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name7").attribute(this.mailPriority(7)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name4").attribute(this.mailPriority(4)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(this.mailPriority(2)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name5").attribute(this.mailPriority(5)).build());
        Iterable items = Flux.from((Publisher)this.getMailQueue().deQueue()).take(10L).flatMap(item -> {
            try {
                item.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
                return Mono.just((Object)item);
            }
            catch (MailQueue.MailQueueException e) {
                return Mono.error((Throwable)e);
            }
        }).toIterable();
        Assertions.assertThat((Iterable)items).extracting(MailQueue.MailQueueItem::getMail).extracting(Mail::getName).containsExactly((Object[])new String[]{"name9", "name8", "name7", "name6", "name5", "name4", "name3", "name2", "name1", "name0"});
    }

    @Test
    default public void negativePriorityShouldDefaultToMinimumPriority() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name0").attribute(this.mailPriority(-1)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(this.mailPriority(1)).build());
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name0");
    }

    @Test
    default public void tooBigPriorityShouldDefaultToMaximalPriority() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name0").attribute(this.mailPriority(12)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(this.mailPriority(8)).build());
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name0");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name1");
    }

    @Test
    default public void invalidPriorityShouldDefaultToNormalPriority() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").attribute(this.mailPriority("invalid")).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(this.mailPriority(4)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name3").attribute(this.mailPriority(6)).build());
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem3 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem3.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name3");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem3.getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void defaultPriorityShouldDefaultToNormalPriority() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name2").attribute(this.mailPriority(4)).build());
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name3").attribute(this.mailPriority(6)).build());
        Iterator mailQueueItems = Flux.from((Publisher)this.getMailQueue().deQueue()).subscribeOn(MailQueueContract.SCHEDULER).toIterable().iterator();
        MailQueue.MailQueueItem mailQueueItem1 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem1.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem2 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem2.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        MailQueue.MailQueueItem mailQueueItem3 = (MailQueue.MailQueueItem)mailQueueItems.next();
        mailQueueItem3.done(MailQueue.MailQueueItem.CompletionStatus.SUCCESS);
        Assertions.assertThat((String)mailQueueItem1.getMail().getName()).isEqualTo("name3");
        Assertions.assertThat((String)mailQueueItem2.getMail().getName()).isEqualTo("name1");
        Assertions.assertThat((String)mailQueueItem3.getMail().getName()).isEqualTo("name2");
    }

    @Test
    default public void priorityCanBeOmitted() throws Exception {
        this.getMailQueue().enQueue((Mail)Mails.defaultMail().name("name1").build());
        MailQueue.MailQueueItem mailQueueItem = (MailQueue.MailQueueItem)Flux.from((Publisher)this.getMailQueue().deQueue()).blockFirst();
        Assertions.assertThat((String)mailQueueItem.getMail().getName()).isEqualTo("name1");
    }

    default public Attribute mailPriority(Object priority) {
        return new Attribute(MailPrioritySupport.MAIL_PRIORITY, AttributeValue.ofAny((Object)priority));
    }
}

