/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import java.time.Instant;
import javax.mail.MessagingException;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class EnqueuedItemTest {
    private MailQueueName mailQueueName = MailQueueName.fromString((String)"mailQueueName");
    private Mail mail = FakeMail.defaultFakeMail();
    private Instant enqueuedTime = Instant.now();
    private MimeMessagePartsId partsId = MimeMessagePartsId.builder().headerBlobId((BlobId)new HashBlobId.Factory().from("headerBlobId")).bodyBlobId((BlobId)new HashBlobId.Factory().from("bodyBlobId")).build();

    EnqueuedItemTest() throws MessagingException {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(EnqueuedItem.class).verify();
    }

    @Test
    void buildShouldThrowWhenEnqueueIdIsNull() {
        Assertions.assertThatThrownBy(() -> EnqueuedItem.builder().enqueueId(null).mailQueueName(this.mailQueueName).mail(this.mail).enqueuedTime(this.enqueuedTime).mimeMessagePartsId(this.partsId).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenMailQueueNameIsNull() {
        Assertions.assertThatThrownBy(() -> EnqueuedItem.builder().enqueueId(EnqueueId.generate()).mailQueueName(null).mail(this.mail).enqueuedTime(this.enqueuedTime).mimeMessagePartsId(this.partsId).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenMailIsNull() {
        Assertions.assertThatThrownBy(() -> EnqueuedItem.builder().enqueueId(EnqueueId.generate()).mailQueueName(this.mailQueueName).mail(null).enqueuedTime(this.enqueuedTime).mimeMessagePartsId(this.partsId).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenEnqueuedTimeIsNull() {
        Assertions.assertThatThrownBy(() -> EnqueuedItem.builder().enqueueId(EnqueueId.generate()).mailQueueName(this.mailQueueName).mail(this.mail).enqueuedTime(null).mimeMessagePartsId(this.partsId).build()).isInstanceOf(NullPointerException.class);
    }

    @Test
    void buildShouldThrowWhenMimeMessagePartsIdIsNull() {
        Assertions.assertThatThrownBy(() -> EnqueuedItem.builder().enqueueId(EnqueueId.generate()).mailQueueName(this.mailQueueName).mail(this.mail).enqueuedTime(this.enqueuedTime).mimeMessagePartsId(null).build()).isInstanceOf(NullPointerException.class);
    }
}

