/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.Instant;
import java.util.Date;
import javax.mail.MessagingException;
import net.javacrumbs.jsonunit.assertj.JsonAssertions;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailReference;
import org.apache.james.queue.rabbitmq.MailReferenceDTO;
import org.apache.james.server.core.MailImpl;
import org.apache.james.util.ClassLoaderUtils;
import org.apache.mailet.Attribute;
import org.apache.mailet.AttributeName;
import org.apache.mailet.AttributeValue;
import org.apache.mailet.Mail;
import org.apache.mailet.PerRecipientHeaders;
import org.apache.mailet.base.MailAddressFixture;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MailDTOTest {
    static final EnqueueId EN_QUEUE_ID = EnqueueId.ofSerialized((String)"110e8400-e29b-11d4-a716-446655440000");
    static final HashBlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();
    static final Date LAST_UPDATED = Date.from(Instant.parse("2016-09-08T14:25:52.000Z"));
    private ObjectMapper objectMapper;

    MailDTOTest() {
    }

    @BeforeEach
    void setUp() {
        this.objectMapper = new ObjectMapper().registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new GuavaModule());
    }

    @Test
    void mailDtoShouldBeSerializedToTheRightFormat() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)this.mailDTO1())).isEqualTo((Object)ClassLoaderUtils.getSystemResourceAsString((String)"json/mail1.json"));
    }

    @Test
    void mailDtoShouldBeDeserializedFromTheRightFormat() throws Exception {
        Assertions.assertThat((Object)((MailReferenceDTO)this.objectMapper.readValue(ClassLoaderUtils.getSystemResourceAsString((String)"json/mail1.json"), MailReferenceDTO.class))).isEqualTo((Object)this.mailDTO1());
    }

    @Test
    void mailDtoShouldBeSerializedWhenOnlyNameAndBlob() throws Exception {
        JsonAssertions.assertThatJson((Object)this.objectMapper.writeValueAsString((Object)this.mailDTOMin())).isEqualTo((Object)ClassLoaderUtils.getSystemResourceAsString((String)"json/mail_min.json"));
    }

    @Test
    void mailDtoShouldBeDeserializedWhenOnlyNameAndBlob() throws Exception {
        Assertions.assertThat((Object)((MailReferenceDTO)this.objectMapper.readValue(ClassLoaderUtils.getSystemResourceAsString((String)"json/mail_min.json"), MailReferenceDTO.class))).isEqualTo((Object)this.mailDTOMin());
    }

    private MailReferenceDTO mailDTO1() throws MessagingException {
        return MailReferenceDTO.fromMailReference((MailReference)new MailReference(EN_QUEUE_ID, (Mail)FakeMail.builder().name("mail-name-558").recipients(new MailAddress[]{MailAddressFixture.RECIPIENT1, MailAddressFixture.RECIPIENT2}).sender(MailAddressFixture.SENDER).attribute(new Attribute(AttributeName.of((String)"att1"), AttributeValue.of((String)"value"))).errorMessage("an error").lastUpdated(LAST_UPDATED).remoteHost("toto.com").remoteAddr("159.221.12.145").addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("X-custom-header").value("uedcgukrcg").build(), MailAddressFixture.RECIPIENT1).addHeaderForRecipient(PerRecipientHeaders.Header.builder().name("X-custom-header-2").value("uedcgukrcg").build(), MailAddressFixture.RECIPIENT2).state("state").build(), MimeMessagePartsId.builder().headerBlobId((BlobId)BLOB_ID_FACTORY.from("210e7136-ede3-44eb-9495-3ed816d6e23b")).bodyBlobId((BlobId)BLOB_ID_FACTORY.from("ef46c026-7819-4048-b562-3a37469191ed")).build()));
    }

    private MailReferenceDTO mailDTOMin() {
        MailImpl mail = MailImpl.builder().name("mail-name-558").build();
        mail.setState(null);
        mail.setLastUpdated(null);
        return MailReferenceDTO.fromMailReference((MailReference)new MailReference(EN_QUEUE_ID, (Mail)mail, MimeMessagePartsId.builder().headerBlobId((BlobId)BLOB_ID_FACTORY.from("210e7136-ede3-44eb-9495-3ed816d6e23b")).bodyBlobId((BlobId)BLOB_ID_FACTORY.from("ef46c026-7819-4048-b562-3a37469191ed")).build()));
    }
}

