/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.api.Store;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.queue.rabbitmq.MailLoader;
import org.apache.james.queue.rabbitmq.MailReference;
import org.apache.james.queue.rabbitmq.MailReferenceDTO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import reactor.core.publisher.Mono;

class MailLoaderTest {
    MailLoaderTest() {
    }

    @Test
    void storeExceptionShouldBePropagated() {
        Store store = (Store)Mockito.mock(Store.class);
        Mockito.when((Object)store.read((Object)((MimeMessagePartsId)Mockito.any()))).thenReturn((Object)Mono.error((Throwable)new RuntimeException("Cassandra problem")));
        MailReferenceDTO dto = (MailReferenceDTO)Mockito.mock(MailReferenceDTO.class);
        Mockito.when((Object)dto.toMailReference((BlobId.Factory)Mockito.any())).thenReturn((Object)((MailReference)Mockito.mock(MailReference.class)));
        MailLoader loader = new MailLoader(store, (BlobId.Factory)new HashBlobId.Factory());
        String result = (String)loader.load(dto).thenReturn((Object)"continued").onErrorResume(RuntimeException.class, e -> Mono.just((Object)"caught")).block();
        Assertions.assertThat((String)result).isEqualTo("caught");
    }
}

