/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import java.util.Optional;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class MailQueueNameTest {
    MailQueueNameTest() {
    }

    @Test
    void fromStringShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> MailQueueName.fromString(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromStringShouldReturnInstanceWhenEmptyString() {
        Assertions.assertThat((Object)MailQueueName.fromString((String)"")).isNotNull();
    }

    @Test
    void fromStringShouldReturnInstanceWhenArbitraryString() {
        Assertions.assertThat((Object)MailQueueName.fromString((String)"whatever")).isNotNull();
    }

    @Test
    void fromRabbitWorkQueueNameShouldThrowWhenNull() {
        Assertions.assertThatThrownBy(() -> MailQueueName.fromRabbitWorkQueueName(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void fromRabbitWorkQueueNameShouldReturnEmptyWhenArbitraryString() {
        Assertions.assertThat((Optional)MailQueueName.fromRabbitWorkQueueName((String)"whatever")).isEmpty();
    }

    @Test
    void fromRabbitWorkQueueNameShouldReturnInstanceWhenPrefixOnlyString() {
        Assertions.assertThat((Optional)MailQueueName.fromRabbitWorkQueueName((String)"JamesMailQueue-workqueue-")).contains((Object)MailQueueName.fromString((String)""));
    }

    @Test
    void fromRabbitWorkQueueNameShouldReturnInstanceWhenValidQueueName() {
        Assertions.assertThat((Optional)MailQueueName.fromRabbitWorkQueueName((String)"JamesMailQueue-workqueue-myQueue")).contains((Object)MailQueueName.fromString((String)"myQueue"));
    }

    @Test
    void shouldConformToBeanContract() {
        EqualsVerifier.forClass(MailQueueName.class).verify();
    }

    @Test
    void exchangeNameShouldConformToBeanContract() {
        EqualsVerifier.forClass(MailQueueName.ExchangeName.class).verify();
    }

    @Test
    void workQueueNameShouldConformToBeanContract() {
        EqualsVerifier.forClass(MailQueueName.WorkQueueName.class).verify();
    }

    @Test
    void fromRabbitWorkQueueNameShouldReturnIdentityWhenToRabbitWorkQueueName() {
        MailQueueName myQueue = MailQueueName.fromString((String)"myQueue");
        Assertions.assertThat((Optional)MailQueueName.fromRabbitWorkQueueName((String)myQueue.toWorkQueueName().asString())).contains((Object)myQueue);
    }
}

