/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq;

import java.time.Clock;
import org.apache.james.backends.rabbitmq.RabbitMQExtension;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.metrics.api.NoopGaugeRegistry;
import org.apache.james.metrics.tests.RecordingMetricFactory;
import org.apache.james.queue.api.MailQueueFactory;
import org.apache.james.queue.api.MailQueueFactoryContract;
import org.apache.james.queue.api.MailQueueItemDecoratorFactory;
import org.apache.james.queue.api.RawMailQueueItemDecoratorFactory;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueue;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueFactory;
import org.apache.james.queue.rabbitmq.RabbitMQMailQueueManagement;
import org.apache.james.queue.rabbitmq.view.RabbitMQMailQueueConfiguration;
import org.apache.james.queue.rabbitmq.view.api.MailQueueView;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import reactor.rabbitmq.QueueSpecification;

class RabbitMqMailQueueFactoryTest
implements MailQueueFactoryContract<RabbitMQMailQueue> {
    private static final HashBlobId.Factory BLOB_ID_FACTORY = new HashBlobId.Factory();
    @RegisterExtension
    static RabbitMQExtension rabbitMQExtension = RabbitMQExtension.singletonRabbitMQ().isolationPolicy(RabbitMQExtension.IsolationPolicy.WEAK);
    private RabbitMQMailQueueFactory mailQueueFactory;
    private RabbitMQMailQueueManagement mqManagementApi;

    RabbitMqMailQueueFactoryTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        MimeMessageStore.Factory mimeMessageStoreFactory = (MimeMessageStore.Factory)Mockito.mock(MimeMessageStore.Factory.class);
        MailQueueView.Factory mailQueueViewFactory = (MailQueueView.Factory)Mockito.mock(MailQueueView.Factory.class);
        MailQueueView mailQueueView = (MailQueueView)Mockito.mock(MailQueueView.class);
        Mockito.when((Object)mailQueueViewFactory.create((MailQueueName)ArgumentMatchers.any())).thenReturn((Object)mailQueueView);
        RabbitMQMailQueueConfiguration configuration = RabbitMQMailQueueConfiguration.builder().sizeMetricsEnabled(true).build();
        RabbitMQMailQueueFactory.PrivateFactory privateFactory = new RabbitMQMailQueueFactory.PrivateFactory((MetricFactory)new RecordingMetricFactory(), (GaugeRegistry)new NoopGaugeRegistry(), rabbitMQExtension.getSender(), rabbitMQExtension.getReceiverProvider(), mimeMessageStoreFactory, (BlobId.Factory)BLOB_ID_FACTORY, mailQueueViewFactory, Clock.systemUTC(), (MailQueueItemDecoratorFactory)new RawMailQueueItemDecoratorFactory(), configuration);
        this.mqManagementApi = new RabbitMQMailQueueManagement(rabbitMQExtension.managementAPI());
        this.mailQueueFactory = new RabbitMQMailQueueFactory(rabbitMQExtension.getSender(), this.mqManagementApi, privateFactory);
    }

    @AfterEach
    void tearDown() {
        this.mqManagementApi.deleteAllQueues();
    }

    public MailQueueFactory<RabbitMQMailQueue> getMailQueueFactory() {
        return this.mailQueueFactory;
    }

    @Test
    void getQueueShouldNotFailWhenTheQueueExistsWithoutDeadLetterSetUp() {
        rabbitMQExtension.getSender().declareQueue(QueueSpecification.queue((String)("JamesMailQueue-workqueue-" + NAME_1.asString())).durable(true).exclusive(false).autoDelete(false)).block();
        this.mailQueueFactory.createQueue(NAME_1);
        Assertions.assertThatCode(() -> this.mailQueueFactory.getQueue(NAME_1)).doesNotThrowAnyException();
    }
}

