/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view;

import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.james.queue.rabbitmq.view.RabbitMQMailQueueConfiguration;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class RabbitMQMailQueueConfigurationTest {
    RabbitMQMailQueueConfigurationTest() {
    }

    @Test
    void shouldMatchBeanContract() {
        EqualsVerifier.forClass(RabbitMQMailQueueConfiguration.class).verify();
    }

    @Test
    void fromShouldReturnDefaultForEmptyConfiguration() {
        RabbitMQMailQueueConfiguration actual = RabbitMQMailQueueConfiguration.from((Configuration)new PropertiesConfiguration());
        Assertions.assertThat((Object)actual).isEqualTo((Object)RabbitMQMailQueueConfiguration.sizeMetricsDisabled());
    }

    @Test
    void fromShouldReturnConfiguredSizeMetricsEnabled() {
        PropertiesConfiguration configuration = new PropertiesConfiguration();
        configuration.addProperty("mailqueue.size.metricsEnabled", (Object)false);
        RabbitMQMailQueueConfiguration actual = RabbitMQMailQueueConfiguration.from((Configuration)configuration);
        Assertions.assertThat((boolean)actual.isSizeMetricsEnabled()).isEqualTo(false);
    }
}

