/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.api;

import java.time.Instant;
import nl.jqno.equalsverifier.EqualsVerifier;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessagePartsId;
import org.apache.james.core.MailAddress;
import org.apache.james.queue.api.ManageableMailQueue;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.EnqueuedItem;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.api.DeleteCondition;
import org.apache.mailet.Mail;
import org.apache.mailet.base.test.FakeMail;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

class DeleteConditionTest {
    private static final String ADDRESS = "any@toto.com";
    private static final String ADDRESS_2 = "any2@toto.com";
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private static final EnqueueId ENQUEUE_ID_1 = EnqueueId.ofSerialized((String)"110e8400-e29b-11d4-a716-446655440000");
    private static final EnqueueId ENQUEUE_ID_2 = EnqueueId.ofSerialized((String)"464765a0-e4e7-11e4-aba4-710c1de3782b");
    private static final MailQueueName OUT_GOING_1 = MailQueueName.fromString((String)"OUT_GOING_1");
    private static final Instant ENQUEUE_TIME = Instant.now();
    private static final MimeMessagePartsId MESSAGE_PARTS_ID = MimeMessagePartsId.builder().headerBlobId((BlobId)new HashBlobId.Factory().from("headerBlobId")).bodyBlobId((BlobId)new HashBlobId.Factory().from("bodyBlobId")).build();

    DeleteConditionTest() {
    }

    private EnqueuedItem enqueuedItemForMail(FakeMail mail) {
        return EnqueuedItem.builder().enqueueId(ENQUEUE_ID_1).mailQueueName(OUT_GOING_1).mail((Mail)mail).enqueuedTime(ENQUEUE_TIME).mimeMessagePartsId(MESSAGE_PARTS_ID).build();
    }

    @Nested
    class ConvertTest {
        ConvertTest() {
        }

        @Test
        void senderShouldBeConvertedToWithSender() {
            Assertions.assertThat((Object)DeleteCondition.from((ManageableMailQueue.Type)ManageableMailQueue.Type.Sender, (String)DeleteConditionTest.VALUE)).isEqualTo((Object)DeleteCondition.withSender((String)DeleteConditionTest.VALUE));
        }

        @Test
        void recipientShouldBeConvertedToWithRecipient() {
            Assertions.assertThat((Object)DeleteCondition.from((ManageableMailQueue.Type)ManageableMailQueue.Type.Recipient, (String)DeleteConditionTest.VALUE)).isEqualTo((Object)DeleteCondition.withRecipient((String)DeleteConditionTest.VALUE));
        }

        @Test
        void nameShouldBeConvertedToWithName() {
            Assertions.assertThat((Object)DeleteCondition.from((ManageableMailQueue.Type)ManageableMailQueue.Type.Name, (String)DeleteConditionTest.VALUE)).isEqualTo((Object)DeleteCondition.withName((String)DeleteConditionTest.VALUE));
        }
    }

    @Nested
    class WithRecipientTest {
        WithRecipientTest() {
        }

        @Test
        void withRecipientShouldThrowOnNullCondition() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withRecipient(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withRecipientShouldThrowOnNullMail() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withRecipient((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withRecipientShouldReturnTrueWhenSameAddress() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withRecipient((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).recipient(DeleteConditionTest.ADDRESS).build()))).isTrue();
        }

        @Test
        void withRecipientShouldReturnTrueWhenAtListOneMatches() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withRecipient((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).recipients(new String[]{DeleteConditionTest.ADDRESS, DeleteConditionTest.ADDRESS_2}).build()))).isTrue();
        }

        @Test
        void withRecipientShouldReturnFalseWhenDifferentAddress() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withRecipient((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).sender(DeleteConditionTest.ADDRESS).recipient(DeleteConditionTest.ADDRESS_2).build()))).isFalse();
        }

        @Test
        void withRecipientShouldReturnFalseWhenNoRecipient() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withRecipient((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).build()))).isFalse();
        }

        @Test
        void shouldMatchBeanContract() {
            EqualsVerifier.forClass(DeleteCondition.WithRecipient.class).verify();
        }
    }

    @Nested
    class WithNameTest {
        WithNameTest() {
        }

        @Test
        void withNameShouldThrowOnNullCondition() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withName(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withNameShouldThrowOnNullMail() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withName((String)DeleteConditionTest.NAME).shouldBeDeleted(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withNameShouldReturnTrueWhenSameName() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withName((String)DeleteConditionTest.NAME).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).build()))).isTrue();
        }

        @Test
        void withSenderShouldReturnFalseWhenDifferentAddress() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withName((String)DeleteConditionTest.NAME).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name("other").build()))).isFalse();
        }

        @Test
        void shouldMatchBeanContract() {
            EqualsVerifier.forClass(DeleteCondition.WithName.class).verify();
        }
    }

    @Nested
    class WithSenderTest {
        WithSenderTest() {
        }

        @Test
        void withSenderShouldThrowOnNullCondition() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withSender(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withSenderShouldThrowOnNullMail() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withSender((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void withSenderShouldReturnTrueWhenSameAddress() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withSender((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).sender(DeleteConditionTest.ADDRESS).build()))).isTrue();
        }

        @Test
        void withSenderShouldReturnFalseWhenDifferentAddress() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withSender((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).sender(DeleteConditionTest.ADDRESS_2).recipient(DeleteConditionTest.ADDRESS).build()))).isFalse();
        }

        @Test
        void withSenderShouldNotThrowOnNullSender() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withSender((String)DeleteConditionTest.ADDRESS).shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).sender(MailAddress.nullSender()).build()))).isFalse();
        }

        @Test
        void withSenderShouldAllowNullSenderMatchingNullSender() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.withSender((String)"<>").shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).sender(MailAddress.nullSender()).build()))).isTrue();
        }

        @Test
        void shouldMatchBeanContract() {
            EqualsVerifier.forClass(DeleteCondition.WithSender.class).verify();
        }
    }

    @Nested
    class WithEnqueueIdTest {
        WithEnqueueIdTest() {
        }

        @Test
        void withSenderShouldThrowOnNullCondition() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.withEnqueueId(null, null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void shouldBeDeletedShouldReturnTrueWhenSameId() throws Exception {
            EnqueuedItem enqueuedItem = EnqueuedItem.builder().enqueueId(ENQUEUE_ID_1).mailQueueName(OUT_GOING_1).mail((Mail)FakeMail.builder().name(DeleteConditionTest.NAME).sender(DeleteConditionTest.ADDRESS).build()).enqueuedTime(ENQUEUE_TIME).mimeMessagePartsId(MESSAGE_PARTS_ID).build();
            Assertions.assertThat((boolean)DeleteCondition.withEnqueueId((EnqueueId)ENQUEUE_ID_1, (MimeMessagePartsId)MESSAGE_PARTS_ID).shouldBeDeleted(enqueuedItem)).isTrue();
        }

        @Test
        void shouldBeDeletedShouldReturnFalseWhenDifferentId() throws Exception {
            EnqueuedItem enqueuedItem = EnqueuedItem.builder().enqueueId(ENQUEUE_ID_2).mailQueueName(OUT_GOING_1).mail((Mail)FakeMail.builder().name(DeleteConditionTest.NAME).sender(DeleteConditionTest.ADDRESS).build()).enqueuedTime(ENQUEUE_TIME).mimeMessagePartsId(MESSAGE_PARTS_ID).build();
            Assertions.assertThat((boolean)DeleteCondition.withEnqueueId((EnqueueId)ENQUEUE_ID_1, (MimeMessagePartsId)MESSAGE_PARTS_ID).shouldBeDeleted(enqueuedItem)).isFalse();
        }
    }

    @Nested
    class AllTest {
        AllTest() {
        }

        @Test
        void allShouldReturnTrue() throws Exception {
            Assertions.assertThat((boolean)DeleteCondition.all().shouldBeDeleted(DeleteConditionTest.this.enqueuedItemForMail(FakeMail.builder().name(DeleteConditionTest.NAME).build()))).isTrue();
        }

        @Test
        void allShouldThrowWhenNull() {
            Assertions.assertThatThrownBy(() -> DeleteCondition.all().shouldBeDeleted(null)).isInstanceOf(NullPointerException.class);
        }

        @Test
        void shouldMatchBeanContract() {
            EqualsVerifier.forClass(DeleteCondition.All.class).verify();
        }
    }
}

