/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.Session;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueViewModule;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import reactor.core.publisher.Mono;

class BrowseStartDAOTest {
    private static final MailQueueName OUT_GOING_1 = MailQueueName.fromString((String)"OUT_GOING_1");
    private static final MailQueueName OUT_GOING_2 = MailQueueName.fromString((String)"OUT_GOING_2");
    private static final Instant NOW = Instant.now();
    private static final Instant NOW_PLUS_TEN_SECONDS = NOW.plusSeconds(10L);
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraSchemaVersionModule.MODULE, CassandraMailQueueViewModule.MODULE}));
    private BrowseStartDAO testee;

    BrowseStartDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new BrowseStartDAO((Session)cassandra.getConf());
    }

    @Test
    void findBrowseStartShouldReturnEmptyWhenTableDoesntContainQueueName() {
        this.testee.updateBrowseStart(OUT_GOING_1, NOW).block();
        Mono firstEnqueuedItemFromQueue2 = this.testee.findBrowseStart(OUT_GOING_2);
        Assertions.assertThat((List)((List)firstEnqueuedItemFromQueue2.flux().collectList().block())).isEmpty();
    }

    @Test
    void findBrowseStartShouldReturnInstantWhenTableContainsQueueName() {
        this.testee.updateBrowseStart(OUT_GOING_1, NOW).block();
        this.testee.updateBrowseStart(OUT_GOING_2, NOW).block();
        Mono firstEnqueuedItemFromQueue2 = this.testee.findBrowseStart(OUT_GOING_2);
        Assertions.assertThat((List)((List)firstEnqueuedItemFromQueue2.flux().collectList().block())).isNotEmpty();
    }

    @Test
    void updateFirstEnqueuedTimeShouldWork() {
        this.testee.updateBrowseStart(OUT_GOING_1, NOW).block();
        Assertions.assertThat((List)((List)this.testee.selectOne(OUT_GOING_1).flux().collectList().block())).isNotEmpty();
    }

    @Test
    void insertInitialBrowseStartShouldInsertFirstInstant() {
        this.testee.insertInitialBrowseStart(OUT_GOING_1, NOW).block();
        this.testee.insertInitialBrowseStart(OUT_GOING_1, NOW_PLUS_TEN_SECONDS).block();
        Assertions.assertThat((List)((List)this.testee.findBrowseStart(OUT_GOING_1).flux().collectList().block())).contains((Object[])new Instant[]{NOW.truncatedTo(ChronoUnit.MILLIS)});
    }
}

