/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.Session;
import java.time.Clock;
import java.util.Optional;
import org.apache.james.blob.api.BlobId;
import org.apache.james.blob.api.HashBlobId;
import org.apache.james.blob.mail.MimeMessageStore;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.BrowseStartDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueBrowser;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailDelete;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueMailStore;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueView;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.EnqueuedMailsDAO;
import org.apache.james.queue.rabbitmq.view.cassandra.configuration.CassandraMailQueueViewConfiguration;

public class CassandraMailQueueViewTestFactory {
    public static CassandraMailQueueView.Factory factory(Clock clock, Session session, CassandraMailQueueViewConfiguration configuration, MimeMessageStore.Factory mimeMessageStoreFactory) {
        HashBlobId.Factory blobIdFactory = new HashBlobId.Factory();
        EnqueuedMailsDAO enqueuedMailsDao = new EnqueuedMailsDAO(session, (BlobId.Factory)blobIdFactory);
        BrowseStartDAO browseStartDao = new BrowseStartDAO(session);
        DeletedMailsDAO deletedMailsDao = new DeletedMailsDAO(session);
        CassandraMailQueueBrowser cassandraMailQueueBrowser = new CassandraMailQueueBrowser(browseStartDao, deletedMailsDao, enqueuedMailsDao, mimeMessageStoreFactory, configuration, clock);
        CassandraMailQueueMailStore cassandraMailQueueMailStore = new CassandraMailQueueMailStore(enqueuedMailsDao, browseStartDao, configuration, clock);
        CassandraMailQueueMailDelete cassandraMailQueueMailDelete = new CassandraMailQueueMailDelete(deletedMailsDao, browseStartDao, cassandraMailQueueBrowser, configuration);
        return new CassandraMailQueueView.Factory(cassandraMailQueueMailStore, cassandraMailQueueBrowser, cassandraMailQueueMailDelete, mimeMessageStoreFactory);
    }

    public static boolean isInitialized(Session session, MailQueueName mailQueueName) {
        BrowseStartDAO browseStartDao = new BrowseStartDAO(session);
        return ((Optional)browseStartDao.findBrowseStart(mailQueueName).map(Optional::ofNullable).defaultIfEmpty(Optional.empty()).block()).isPresent();
    }
}

