/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.rabbitmq.view.cassandra;

import com.datastax.driver.core.Session;
import org.apache.james.backends.cassandra.CassandraCluster;
import org.apache.james.backends.cassandra.CassandraClusterExtension;
import org.apache.james.backends.cassandra.components.CassandraModule;
import org.apache.james.backends.cassandra.versions.CassandraSchemaVersionModule;
import org.apache.james.queue.rabbitmq.EnqueueId;
import org.apache.james.queue.rabbitmq.MailQueueName;
import org.apache.james.queue.rabbitmq.view.cassandra.CassandraMailQueueViewModule;
import org.apache.james.queue.rabbitmq.view.cassandra.DeletedMailsDAO;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;

class DeletedMailsDAOTest {
    private static final MailQueueName OUT_GOING_1 = MailQueueName.fromString((String)"OUT_GOING_1");
    private static final MailQueueName OUT_GOING_2 = MailQueueName.fromString((String)"OUT_GOING_2");
    private static final EnqueueId ENQUEUE_ID_1 = EnqueueId.ofSerialized((String)"110e8400-e29b-11d4-a716-446655440000");
    private static final EnqueueId ENQUEUE_ID_2 = EnqueueId.ofSerialized((String)"464765a0-e4e7-11e4-aba4-710c1de3782b");
    @RegisterExtension
    static CassandraClusterExtension cassandraCluster = new CassandraClusterExtension(CassandraModule.aggregateModules((CassandraModule[])new CassandraModule[]{CassandraSchemaVersionModule.MODULE, CassandraMailQueueViewModule.MODULE}));
    private DeletedMailsDAO testee;

    DeletedMailsDAOTest() {
    }

    @BeforeEach
    void setUp(CassandraCluster cassandra) {
        this.testee = new DeletedMailsDAO((Session)cassandra.getConf());
    }

    @Test
    void markAsDeletedShouldWork() {
        Boolean isDeletedBeforeMark = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeletedBeforeMark).isFalse();
        this.testee.markAsDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Boolean isDeletedAfterMark = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeletedAfterMark).isTrue();
    }

    @Test
    void checkDeletedShouldReturnFalseWhenTableDoesntContainBothMailQueueAndMailKey() {
        this.testee.markAsDeleted(OUT_GOING_2, ENQUEUE_ID_2).block();
        Boolean isDeleted = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeleted).isFalse();
    }

    @Test
    void checkDeletedShouldReturnFalseWhenTableContainsMailQueueButNotMailKey() {
        this.testee.markAsDeleted(OUT_GOING_1, ENQUEUE_ID_2).block();
        Boolean isDeleted = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeleted).isFalse();
    }

    @Test
    void checkDeletedShouldReturnFalseWhenTableContainsMailKeyButNotMailQueue() {
        this.testee.markAsDeleted(OUT_GOING_2, ENQUEUE_ID_1).block();
        Boolean isDeleted = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeleted).isFalse();
    }

    @Test
    void checkDeletedShouldReturnTrueWhenTableContainsMailItem() {
        this.testee.markAsDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Boolean isDeleted = (Boolean)this.testee.isDeleted(OUT_GOING_1, ENQUEUE_ID_1).block();
        Assertions.assertThat((Boolean)isDeleted).isTrue();
    }
}

